$(document).ready(function() {
    // Au clic sur le bouton
    $('.wishlist-button').on('click', function(e) {
        e.preventDefault();

        var $btn = $(this);
        var idProduct = $btn.data('product-id');

        $.ajax({
            url: prestashop.urls.base_url + 'module/polarisprestatheme/ajaxwishlist',
            type: 'POST',
            data: { id_product: idProduct },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    if (data.action === 'added') {
                        // Ajout à la wishlist => cœur noir
                        $btn.addClass('active');
                    } else if (data.action === 'removed') {
                        // Suppression => cœur vide
                        $btn.removeClass('active');
                    }
                } else {
                    alert(data.message);
                }
            },
            error: function() {
                alert('Erreur lors de la mise à jour de la wishlist.');
            }
        });
    });

    //  Au chargement de la page : coche les produits déjà dans la wishlist
    if (window.userWishlist && Array.isArray(window.userWishlist)) {
        $('.wishlist-button').each(function() {
            var idProduct = parseInt($(this).data('product-id'));
            if (window.userWishlist.includes(idProduct)) {
                $(this).addClass('active');
            }
        });
    }
});
