document.addEventListener('DOMContentLoaded', function () {

  const medias = document.querySelector('#menu_media_medias');
  if(medias){
    const imageFields = document.querySelectorAll('input[type="file"]');
    imageFields.forEach(function (imageField) {
      // Extraire l’index dans le nom : menu_media_medias_0_image => 0
      const match = imageField.id.match(/menu_media_medias_(\d+)_image/);
      if (!match) return;
      const index = match[1];

      const imagePreview = document.querySelector('.img-form[data-index="'+index+'"]');
      if (imagePreview) {
        // Trouver le conteneur .custom-file qui entoure l’input
        const customFileDiv = imageField.closest('.custom-file');

        if (customFileDiv) {
          // Insérer l’image juste après ce <div class="custom-file">
          customFileDiv.insertAdjacentElement('afterend', imagePreview);
          imagePreview.style.display = 'block';

          // Mettre à jour l’aperçu en live si on change l’image
          imageField.addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
              const reader = new FileReader();
              reader.onload = function(e) {
                imagePreview.src = e.target.result;
              };
              reader.readAsDataURL(file);
            }
          });
        }
      }
    });

  }else{
    const imageField = document.querySelector('.custom-file');
    const imagePreview = document.querySelector('.img-form');
    

    if (imageField && imagePreview) {
          // Insère le bloc d’image juste après l’élément input
          imageField.insertAdjacentElement('afterend', imagePreview);
          imagePreview.style.display = 'block';
        
    }
  }
    
 
  
  // Récupère le conteneur principal de la collection (généré automatiquement par Symfony)
  const collectionHolder = document.getElementById('menu_media_medias');
  if(collectionHolder){

 
  // Récupère le bouton "Ajouter une image"
  const addButton = document.getElementById('add-media');

  // Si le conteneur ou le bouton n'existent pas dans la page, on ne fait rien
  if (!collectionHolder || !addButton) return;

  // Initialise l'index à la quantité actuelle de blocs dans le DOM
  let index = collectionHolder.children.length;

  // Fonction qui active ou désactive le bouton "Ajouter" selon le nombre d'éléments
  const refreshAddButtonState = () => {
    addButton.disabled = collectionHolder.children.length >= 3;
  };

  // Fonction qui crée un nouveau bloc à partir du prototype
  const createBlock = () => {
    // Remplace tous les "__name__" du prototype par l'index courant
    const prototype = collectionHolder.dataset.prototype.replace(/__name__/g, index);

    // Crée un élément div pour contenir le nouveau bloc
    const div = document.createElement('div');
   

    // Injecte le HTML du prototype dans ce bloc
    div.innerHTML = prototype;

    // Crée le bouton "Supprimer"
    const removeButton = document.createElement('button');
    removeButton.type = 'button';
    removeButton.className = 'btn btn-danger remove-media mt-2';
    removeButton.textContent = 'Supprimer';

    // Lorsqu'on clique sur "Supprimer", on enlève le bloc du DOM et on met à jour le bouton "Ajouter"
    removeButton.addEventListener('click', () => {
      div.remove();
      refreshAddButtonState();
    });

    // Ajoute le bouton "Supprimer" à la fin du bloc
    div.appendChild(removeButton);

    // Ajoute le bloc complet à la collection
    collectionHolder.appendChild(div);

    // Incrémente l'index pour le prochain ajout
    index++;

    // Met à jour l'état du bouton "Ajouter"
    refreshAddButtonState();
  };

  // Lorsqu'on clique sur le bouton "Ajouter une image", on crée un nouveau bloc
  addButton.addEventListener('click', createBlock);

  // Pour chaque bouton "Supprimer" déjà présent dans la page (rendu initial), on ajoute le comportement
  collectionHolder.querySelectorAll('.remove-media').forEach(btn => {
    btn.addEventListener('click', () => {
      btn.closest('.media-entry').remove(); // Supprime le bloc parent
      refreshAddButtonState();              // Met à jour l'état du bouton
    });
  });

  // Vérifie dès le départ si le bouton "Ajouter" doit être désactivé
  refreshAddButtonState();

  }

});