<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class NewProductType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])
        
        ->add('nbProduit', IntegerType::class,[
            'label'    => 'Produits à afficher',
            'attr' => ['min' => 4, 'max' => 20],
            "attr"=>[
                "placeholder" => "Ajouter un nombre de produits à afficher (entre 4 et 20)"
            ]
         ])
       
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet d\'afficher un bloc dédié aux nouveaux produits </br>
        - Activez ou désactivez l\'affichage de ce bloc grâce à l\'interrupteur "Activer la visibilité".</br>
        - Définissez le nombre de produits à afficher dans ce bloc.</br></br>

        Si vous affichez plus de 4 produits, ceux-ci seront automatiquement présentés sous forme de slider défilant pour une meilleure ergonomie.
        ';
    }


}