<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Manufacturer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class BrandType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité du bloc marques partenaires',
        ])

        ->add('btn',SwitchType::class, [
            'required' => false,
            'label' => 'Activer le bouton "voir les autres marques"',
        ])

        ->add('title', TextType::class, [
            'label' => 'Titre',
            'empty_data' => '',
            'required' => false,
            'help' => 'Laisser vide pour ne pas afficher de titre',
            'attr' => [
                'placeholder' => 'Titre du block marque',
            ]

        ])

        ->add('style', ChoiceType::class, [
            'choices' => [
                'Block arque 1' => 'brand1',
                'Block marque 2' => 'brand2',
            ],
            'label' => 'Choisissez un style de bloc marques partenaires',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],

            'choice_label' => function($choice) {
            $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
            // Associe chaque option à une image
            switch ($choice) {
                case 'brand1':
                    return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/blockcategorie1.jpeg" alt="Block categorie 1" />';
                case 'brand2':
                    return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/blockcategorie2.jpeg" alt="Block categorie 2" /> ';
            }
        },
    
        'required' => true,
        ])

        ->add('selected_brands', ChoiceType::class, [
            'choices' => $this->getBrandChoices(),
            'multiple' => true,
            'expanded' => true, // met à false si tu veux une liste déroulante au lieu de cases à cocher
            'label' => 'Sélectionnez les marques à mettre en avant',
            'required' => true,
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }


    private function getBrandChoices(): array
    {
        $brands = Manufacturer::getManufacturers(false, \Context::getContext()->language->id);
        $choices = [];
        foreach ($brands as $brand) {
            $choices[$brand['name']] = (int)$brand['id_manufacturer'];
        }
        return $choices;
    }

    public static function getIntro(): ?string
    {
        return 'Ce bloc permet de configurer l’affichage des marques partenaires.</br>
        - Vous pouvez choisir d’afficher ou non le bouton « Voir les autres marques », qui redirige vers la page dédiée.<br>
        - Vous pouvez Renseignez un titre pour la catégorie ou le laisser vide. <br>
        - Vous pouvez sélectionner le style d’affichage du bloc (le Style 2 propose un défilement infini animé).<br>
        - Vous pouvez également sélectionner les marques à mettre en avant dans ce bloc.
        ';
    }


}