<?php
namespace PrestaShop\Module\PolarisPrestaTheme\Config;

use Category;
use Context;
use Link;

class ConfigMenuParent
{
    public $menu;  // int ou array enrichi
    public $isVisible = true;

    /**
     * enrichit le menu avec les données de la catégorie
     */
    public function enrich(): void
    {
        $link = new Link();
        $id_lang = Context::getContext()->language->id;
        $category = new Category((int) $this->menu, $id_lang);

        $this->menu = [
            'id' => $category->id,
            'name' => $category->name,
            'url' => $link->getCategoryLink($category),
            'columns' => []
        ];
    }

    /**
     * Ajoute une colonne au menu
     *
     * @param array $column La colonne à ajouter, contenant des blocs de catégories et d'enfants
     */
    public function addColumn(array $column): void
    {
        if (!isset($this->menu['columns'])) {
            $this->menu['columns'] = [];
        }
        $this->menu['columns'][] = $column;
    }
}
