{extends file='page.tpl'}

{block name='page_title'}
  <div class="title-all">
    {l s='Our stores' d='Shop.Theme.Global'}
  </div>
{/block}

{block name='page_content_container'}
  <section id="content" class="page-content page-stores">
    <div class="row">
      <div class="map col-sm-12"></div>
    </div>
    <div class="row">
      {foreach $stores as $store}
        {assign var="grouped_hours" value=[]}
        {assign var="last_hours" value=null}
        {assign var="days" value=[]}

        {foreach $store.business_hours as $day}
            {assign var="current_hours" value=""}
            {foreach $day.hours as $h}
                {assign var="current_hours" value=$current_hours|cat:" "|cat:$h}
            {/foreach}

            {if $current_hours == $last_hours}
                {assign var="days" value=array_merge($days, [$day.day])}
            {else}
                {if $days|@count > 1}
                    {$grouped_hours[] = ["days" => $days, "hours" => $last_hours]}
                {elseif $days|@count == 1}
                    {$grouped_hours[] = ["days" => [$days.0], "hours" => $last_hours]}
                {/if}
                
                {assign var="days" value=[$day.day]}
                {assign var="last_hours" value=$current_hours}
            {/if}
        {/foreach}

        {if $days|@count > 1}
            {$grouped_hours[] = ["days" => $days, "hours" => $last_hours]}
        {elseif $days|@count == 1}
            {$grouped_hours[] = ["days" => [$days.0], "hours" => $last_hours]}
        {/if}

        <article id="store-{$store.id}" class="col-xs-12 col-sm-12 col-md-6 col-lg-4 store-item">
          <div class="store-item-container">
              <div class="store-name">
                <p class="h3 card-title">{$store.name}</p>
              </div>
              <div class="store-info">
                <div class="store-address">
                  <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M480-480q33 0 56.5-23.5T560-560q0-33-23.5-56.5T480-640q-33 0-56.5 23.5T400-560q0 33 23.5 56.5T480-480Zm0 294q122-112 181-203.5T720-552q0-109-69.5-178.5T480-800q-101 0-170.5 69.5T240-552q0 71 59 162.5T480-186Zm0 106Q319-217 239.5-334.5T160-552q0-150 96.5-239T480-880q127 0 223.5 89T800-552q0 100-79.5 217.5T480-80Zm0-480Z"/></svg>
                  <span class="store-info-txt">
                    <address>{$store.address.formatted|regex_replace:'/France/i':'' nofilter}</address>
                  </span>
                </div>
                
                {if $store.phone}
                  <div class="store-phone">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M798-120q-125 0-247-54.5T329-329Q229-429 174.5-551T120-798q0-18 12-30t30-12h162q14 0 25 9.5t13 22.5l26 140q2 16-1 27t-11 19l-97 98q20 37 47.5 71.5T387-386q31 31 65 57.5t72 48.5l94-94q9-9 23.5-13.5T670-390l138 28q14 4 23 14.5t9 23.5v162q0 18-12 30t-30 12ZM241-600l66-66-17-94h-89q5 41 14 81t26 79Zm358 358q39 17 79.5 27t81.5 13v-88l-94-19-67 67ZM241-600Zm358 358Z"/></svg>
                    <span class="store-info-txt">{$store.phone}</span>
                  </div>
                {/if}
                
                {if $store.email}
                  <div class="store-email">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Zm320-280L160-640v400h640v-400L480-440Zm0-80 320-200H160l320 200ZM160-640v-80 480-400Z"/></svg>
                    <span class="store-info-txt">{$store.email}</span>
                  </div>
                {/if}
                
                <div class="store-hour">
                  <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M480-240q100 0 170-70t70-170q0-100-70-170t-170-70v240L310-310q35 33 78.5 51.5T480-240Zm0 160q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"/></svg>
                  <div class="store-info-txt">
                    {foreach $grouped_hours as $group}
                      {if $group.days|@count > 1}
                        <span>Du {$group.days[0]|truncate:4:' '} à {$group.days[$group.days|@count-1]|truncate:4:' '} :
                        {else}
                          <span>{$group.days[0]|truncate:4:' '} :
                      {/if}
                      {$group.hours}</span>
                    {/foreach}                    
                  </div>
                </div>
                
                {if $store.note}
                  <div class="store-note">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M200-120v-640q0-33 23.5-56.5T280-840h400q33 0 56.5 23.5T760-760v640L480-240 200-120Zm80-122 200-86 200 86v-518H280v518Zm0-518h400-400Z"/></svg>
                    <span class="store-info-txt">{$store.note}</span>
                  </div>
                {/if}
              </div>
          </div>
        </article>
      {/foreach}
    </div>
  </section>
{/block}
