/*
* dyncache.js
* 
* Recherche et met à jour les variables du thème sur une page de cache statique
*
* usage: <div class="user-tag" data-varcache="cache.customer.initials">
              Non connecté
         </div>
*/

/* 
    DynDataResolver résout toutes les variables du DOM
    avec les dernières informations tirées du serveur
*/
class DynDataResolver {

    /**
     * Nos données dynamiques
     */
    data = null;


    /**
     * Lire les données dynamique du body lorsqu'elles sont présentes
     */
    readDataFromBody() {
        const el = document.getElementById("data_cache");
        if (!el) return;

        const data = el.dataset.var; // équivalent de $("#data_cache").data("var")
        if (data) {
            window.localStorage.setItem("dyn-data", atob(data));
        }
    }

    /*
    * Tirage des données depuis le serveur
    */
    injectData(data) {
        window.localStorage.setItem("dyn-data", JSON.stringify(data));
        this.loadData();
    }

    /*
    * Charge les données à afficher
    */
    loadData() {
        this.data = JSON.parse(window.localStorage.getItem("dyn-data")) ?? null;
    }

    /*
    * Parcours du DOM et remplacement avec nos données
    */
    run() {
        this.readDataFromBody();
        this.loadData();

        let ignoredNoCache = [];

        // Tous les éléments avec la variable data-cache-var        
        document.querySelectorAll("[data-varcache]").forEach((e) => {

            try {
                if (!ignoredNoCache.includes(e)) {

                    // Attribut data-var
                    let value = e.dataset.varcache;
                    if (value) {
                        let evaluedValue = null;
                        try
                        {
                            value = value.replace(/cache\./g, 'this.data.');
                            evaluedValue = eval(value);
                        }
                        catch(err)
                        {
                            // Erreur sans conséquence
                            console.error(err);
                        }

                        if (evaluedValue !== null) {
                            e.innerHTML = evaluedValue;                            
                        }
                    }                    

                    // Attribut data-if
                    let condition = e.dataset.if; 
                    if (condition) {
                        if (!eval(condition)) {
                            // On ajoute les enfants .no-cache à la liste ignorée
                            e.querySelectorAll("[data-varcache]").forEach(e1 => ignoredNoCache.push(e1));

                            e.innerHTML = "";
                        }
                    }
                }
            } catch (error) {
                e.innerHTML = `<span style="color: red !important">[[${error.message}]]</span>`;
                console.error(error);
            }
        });

        /*document.querySelectorAll("[data-varcache]").forEach(el => {
            el.style.opacity = "1";
        });*/
    }
}

// Application du cache
document.addEventListener("DOMContentLoaded", () => {
    const dynDataResolver = new DynDataResolver();
    dynDataResolver.run();
});
