{if !empty($menus)}
<ul id="top-menu" class="main-menu top-menu">
  {foreach from=$menus item=parent}
    {if $parent->isVisible}
      <li class="menu-item" data-level="1">
        {* Niveau 1 – parent principal *}
        <div class="title-group" data-level="1">
          <a class="menu-title {$parent->menu.name}" href="{$parent->menu.url}" data-level="1">
            {$parent->menu.name}
          </a>
          <svg xmlns="http://www.w3.org/2000/svg" data-level="1" class="{if $parent->menu.columns|@count > 0}add{else}no-child{/if}" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3">
            <path d="M480-344 240-584l56-56 184 184 184-184 56 56-240 240Z"/>
          </svg>
        </div>

        {if $parent->menu.columns|@count > 0}
          <ul class="submenu columns" data-level="2">
            <div class="container">
              {foreach from=$parent->menu.columns item=column}
                {if $column.isVisible}
                  <li class="{if $column.type == 'media'}column-media {else}column{/if}" data-level="2">
                    {* Niveau 2 – colonne *}
                    {foreach from=$column.blocks item=sub}
                      {if $column.type == 'media'}
                        {* Bloc média *}
                        <div class="media-item" data-level="2">
                          <a href="{$sub.url}" data-level="2">
                            <img src="{$sub.image}" alt="{$sub.title}" class="media-image" />
                            {if $sub.title}
                              <div class="media-title">{$sub.title}</div>
                            {/if}
                          </a>
                        </div>
                      {else}
                        {* Niveau 2 – titre de colonne *}
                        <div class="sub-title-group" data-level="2">
                          <a class="sub-title level-2 {if $sub.children|@count > 0}bold-title{/if}" href="{$sub.url}" data-level="2">
                            {$sub.name}
                          </a>
                          <svg xmlns="http://www.w3.org/2000/svg" data-level="2" class="{if $sub.children|@count > 0}add{else}no-child{/if}" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3">
                            <path d="M480-344 240-584l56-56 184 184 184-184 56 56-240 240Z"/>
                          </svg>
                        </div>

                        {if $sub.children|@count > 0}
                          {assign var="hasNestedChildren" value=false}
                          {foreach from=$sub.children item=child}
                            {if $child.children|@count > 0}
                              {assign var="hasNestedChildren" value=true}
                              {break}
                            {/if}
                          {/foreach}

                          <ul class="sub-children {if $hasNestedChildren}last-child{/if} level-3" data-level="3">
                            {foreach from=$sub.children item=child}
                              <li class="sub-child-column" data-level="3">
                                <div class="sub-child-title-group" data-level="3">
                                  <a class="{if $child.children|@count > 0}sub-child-title{else}child-title{/if} level-3" href="{$child.url}" data-level="3">
                                    {$child.name}
                                  </a>
                                  <svg xmlns="http://www.w3.org/2000/svg" data-level="3" class="{if $child.children|@count > 0}add{else}no-child{/if}" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3">
                                    <path d="M480-344 240-584l56-56 184 184 184-184 56 56-240 240Z"/>
                                  </svg>
                                </div>

                                {if $child.children|@count > 0}
                                  <ul class="sub-child-children" data-level="4">
                                    {foreach from=$child.children item=grandChild}
                                      <li class="level-4" data-level="4">
                                        <a class="grand-child-title level-4" href="{$grandChild.url}" data-level="4">
                                          {$grandChild.name}
                                        </a>
                                      </li>
                                    {/foreach}
                                  </ul>
                                {/if}
                              </li>
                            {/foreach}
                          </ul>
                        {/if}
                      {/if}
                    {/foreach}
                  </li>
                {/if}
              {/foreach}
            </div>
          </ul>
        {/if}
      </li>
    {/if}
  {/foreach}
</ul>
{/if}


<script src="{$urls.base_url}modules/polarisprestatheme/views/js/menu.js"></script>