<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class TopBandeauType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité ',
        ])
        
        ->add('text', TextType::class,[
            'label'    => 'message  pour le bandeau',
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "ajouter votre message "
            ]
         ])

       
        ->add('image', FileType::class ,[
            'label' => 'logo pour le bandeau', 
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

      public static function getIntro(): ?string
    {
        return 'Cette page vous permet de configurer le bandeau affiché en haut du site.</br>
        - Activez ou désactivez l’affichage du bandeau à l’aide du bouton dédié.</br>
        - Saisissez un message personnalisé (ex. : Livraison gratuite à partir de 50€).</br>
        - Importez un logo ou une icône qui sera affiché à côté du message.</br><br>

        Voici un lien pour accéder aux icônes : <a style="color:black; font-weight:700;" href="https://www.flaticon.com">ICI</a> exportez vos icônes en format 32px maximum pour garantir un affichage optimal
        ';
    }


}