<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;


class ProductType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('reduction',SwitchType::class, [
            'label'    => 'Afficher les bons de reduction disponible pour le client',
            'required' => false,
        ])

        ->add('quantity',SwitchType::class, [
            'label'    => 'Afficher  le champ quantité sur la fiche produit',
            'required' => false,
        ])

        ->add('information', ChoiceType::class, [
            'choices' => [
                'affichage information produit 1' => 'information1',
                'affichage information produit 2' => 'information2',
            ],
            'label' => 'Choisissez l\'affichage des informations produit',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],
            'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'information1':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/information1.jpeg" alt="information1" />';
                    case 'information2':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/information2.jpeg" alt="information2" />';
                }
            },
            'required' => true,
        ])

        ->add('imagePosition', ChoiceType::class, [
            'choices' => [
                'Image supplementaire à gauche' => 'imagesuppGauche',
                'Image supplementaire à droite' => 'imagesuppDroite',
                'Image supplementaire en bas' => 'imagesuppBas',
            ],
            'label' => 'Choisissez la disposition des images supplementaires',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],
            'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'imagesuppGauche':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/imagesuppgauche.jpeg" alt="Filtre gauche" />';
                    case 'imagesuppDroite':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/imagesuppdroite.jpeg" alt="Filtre droite" />';
                    case 'imagesuppBas':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/imagesuppbas.jpeg" alt="Filtre bas" />';
                }
            },
           
            'required' => true,
        ])
            
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])

        ;
       
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser l’affichage des informations sur la fiche produit.</br>
        - Afficher ou masquer le champ quantité sur la fiche produit.</br>
        - Choisir le style d’affichage des informations produit : Onglets horizontaux (classique), Accordeons déroulants (plus compact)</br>
        - Définir la disposition des images supplémentaires autour de l’image principale (à gauche, à droite ou en bas).</br></br>

        Ces réglages permettent d’adapter l’interface produit à votre style de thème et d’optimiser l’expérience utilisateur selon vos préférences.
        ';
    }

}