<?php

class PolarisPrestaThemeWishlistModuleFrontController extends ModuleFrontController
{
    /**
     * Chargement des fichiers JS et CSS nécessaires
     */
    public function setMedia()
    {
        parent::setMedia();

        // Ajoute ton JS ici (dans le répertoire du module)
        $this->registerJavascript(
            'module-prestatheme-wishlist', // Identifiant unique du script
            'modules/' . $this->module->name . '/views/js/wishlist.js', // Chemin relatif vers le fichier JS
            [
                'position' => 'bottom', // Charge le script en bas de la page
                'priority' => 150,      // Détermine l'ordre de chargement
            ]
        );
    }

    /**
     * Initialisation du contenu de la page Wishlist
     */
    public function initContent()
    {
        parent::initContent(); // Appel du parent pour initialiser le contenu de base

        // Récupération du client connecté
        $idCustomer = (int) $this->context->customer->id;

        // Création d’un objet Link pour générer les URLs produits
        $link = new Link();

        // Initialisation du tableau final de produits
        $products = [];

        // Vérifie si un client est connecté
        if ($idCustomer) {

            // Récupération des produits enregistrés dans la wishlist du client
            $wishlistProducts = Db::getInstance()->executeS('
                SELECT id_product
                FROM `' . _DB_PREFIX_ . 'wishlist`
                WHERE id_customer = ' . (int) $idCustomer
            );

            // Boucle sur chaque produit de la wishlist
            foreach ($wishlistProducts as $item) {
                $idProduct = (int) $item['id_product'];

                // Création de l’objet produit (chargé dans la langue actuelle)
                $productObj = new Product($idProduct, false, $this->context->language->id);

                // Récupération de l’image principale du produit
                $cover = Product::getCover($idProduct);
                $idCover = isset($cover['id_image']) ? (int) $cover['id_image'] : null;

                // Récupération de toutes les images du produit
                $images = $productObj->getImages($this->context->language->id);

                // Récupération des combinaisons (tailles, couleurs, etc.)
                $combinations = $productObj->getAttributeCombinations($this->context->language->id);

                // Préparation des structures de données
                $attributes = [];           // Liste des attributs par groupe
                $combinationsForJs = [];    // Structure simplifiée pour le JS

                // Boucle sur toutes les combinaisons disponibles
                foreach ($combinations as $comb) {
                    $idCombination = (int) $comb['id_product_attribute'];
                    $idAttribute = (int) $comb['id_attribute'];
                    $idAttributeGroup = (int) $comb['id_attribute_group'];
                    $groupName = strtolower($comb['group_name']);
                    $attrName = $comb['attribute_name'];

                    // Récupération du stock disponible pour cette combinaison
                    $quantity = (int) StockAvailable::getQuantityAvailableByProduct($idProduct, $idCombination);

                    // Si la combinaison est en rupture, on l’ignore
                    if ($quantity <= 0) {
                        continue;
                    }

                    // Construction de la liste d’attributs par groupe
                    if (!isset($attributes[$idAttributeGroup])) {
                        $attributes[$idAttributeGroup] = [
                            'group_name' => $groupName,
                            'id_attribute_group' => $idAttributeGroup,
                            'options' => [],
                        ];
                    }

                    // Vérifie si cet attribut n’existe pas déjà dans le groupe
                    $existing = array_column($attributes[$idAttributeGroup]['options'], 'id_attribute');
                    if (!in_array($idAttribute, $existing)) {
                        $attributes[$idAttributeGroup]['options'][] = [
                            'id_attribute' => $idAttribute,
                            'attribute_name' => $attrName,
                        ];
                    }

                    // Construction des combinaisons pour le JS
                    if (!isset($combinationsForJs[$idCombination])) {
                        $combinationsForJs[$idCombination] = [
                            'size_id'  => null,
                            'color_id' => null,
                            'quantity' => $quantity,
                        ];
                    }

                    // Attribution des IDs selon le type de groupe
                    if ($groupName === 'taille' || $groupName === 'size') {
                        $combinationsForJs[$idCombination]['size_id'] = $idAttribute;
                    } elseif ($groupName === 'couleur' || $groupName === 'color') {
                        $combinationsForJs[$idCombination]['color_id'] = $idAttribute;
                    } else {
                        // Si d'autres groupes existent (ex : matière), tu peux les gérer ici
                    }
                }

                // Ajout du produit complet au tableau final
                $products[] = [
                    'id_product'        => $idProduct,
                    'name'              => Product::getProductName($idProduct, null, $this->context->language->id),
                    'price_ttc'         => $productObj->getPrice(true),
                    'link'              => $link->getProductLink($productObj),
                    'id_cover'          => $idCover,
                    'image'             => $images,
                    'attributes'        => $attributes,
                    'combinations_json' => json_encode($combinationsForJs),
                ];
            }
        }

        // Assignation des produits à Smarty
        $this->context->smarty->assign([
            'wishlist' => !empty($products) ? $products : [], // Si aucun produit, tableau vide
        ]);

        // Définition du template à afficher
        $this->setTemplate('module:polarisprestatheme/views/templates/front/wishlist.tpl');
    }
}