{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
<div class="col-md-12 links">
  <div class="row">
  {foreach $linkBlocks as $linkBlock}
    <div class="col-md-3 wrapper">
      <p class="h3 hidden-sm-down">{$linkBlock.title}</p>
      <div class="title clearfix hidden-md-up" data-target="#footer_sub_menu_{$linkBlock.id}" data-toggle="collapse">
        <span class="h3">{$linkBlock.title}</span>
        <span class="float-xs-right">
          <span class="navbar-toggler collapse-icons">
          <svg xmlns="http://www.w3.org/2000/svg" class="add" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M504-480 320-664l56-56 240 240-240 240-56-56 184-184Z"/></svg>
          <svg xmlns="http://www.w3.org/2000/svg" class="remove" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M480-344 240-584l56-56 184 184 184-184 56 56-240 240Z"/></svg>
          </span>
        </span>
      </div>
      <ul id="footer_sub_menu_{$linkBlock.id}" class="collapse">
        {foreach $linkBlock.links as $link}
          <li>
            <a
                id="{$link.id}-{$linkBlock.id}"
                class="{$link.class}"
                href="{$link.url}"
                title="{$link.description}"
                {if !empty($link.target)} target="{$link.target}" {/if}
            >
              {$link.title}
            </a>
          </li>
        {/foreach}
      </ul>
    </div>
  {/foreach}
    <div class="col-md-3 wrapper">
        <p class="h3 hidden-sm-down">Suivez-nous</p>
        <div class="title clearfix hidden-md-up" data-target="#footer_sub_menu_4" data-toggle="collapse">
          <span class="h3">Suivez-nous</span>
          <span class="float-xs-right">
            <span class="navbar-toggler collapse-icons">
              <svg xmlns="http://www.w3.org/2000/svg" class="add" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M504-480 320-664l56-56 240 240-240 240-56-56 184-184Z"/></svg>
              <svg xmlns="http://www.w3.org/2000/svg" class="remove" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M480-344 240-584l56-56 184 184 184-184 56 56-240 240Z"/></svg>
            </span>
          </span>
        </div>
          <ul id="footer_sub_menu_4"class="collapse sociaux-footer"> 
            {hook h="displaySociaux"}
          </ul>
    </div>
  </div>
</div>

