// Quand le DOM est entièrement chargé…
document.addEventListener("DOMContentLoaded", function () {

    // On récupère le conteneur du menu mobile
    const menuWrapper = document.querySelector('#mobile_top_menu_wrapper');
    if (!menuWrapper) return; // Si pas trouvé, on ne fait rien

    // Bouton pour fermer le menu
    const closeButton = menuWrapper.querySelector('.close-buton');

    // Bouton pour revenir en arrière (navigation)
    const backButton = menuWrapper.querySelector('.back-button');

    // Élément HTML qui affichera le fil d’Ariane
    const breadcrumbEl = menuWrapper.querySelector('.breadcrumb-path-menu');

    // Stack pour mémoriser les menus ouverts à chaque niveau
    let menuStack = [];

    // Liste des titres des menus ouverts, pour afficher le fil d’Ariane
    let breadcrumbPath = [];

    // Quand on ferme complètement le menu
    closeButton.addEventListener('click', function () {
        // Réaffiche le wrapper général du site
        document.querySelector('#wrapper').style.display = "block";
        document.querySelector('#footer').style.display = "block";

        // Cache le menu mobile
        menuWrapper.style.display = "none";

        // Ferme tous les sous-menus et réaffiche tous les éléments
        menuWrapper.querySelectorAll('[data-level]').forEach(el => {
            el.classList.remove('open', 'hide_menu');
        });

        // Cache le bouton retour
        backButton.style.opacity = '0';

        // Vide le fil d'Ariane
        breadcrumbEl.textContent = '';

        // Réinitialise les structures de navigation
        menuStack = [];
        breadcrumbPath = [];
    });

    // Fonction appelée lorsqu'on clique sur un menu pour ouvrir un sous-menu
    function handleMenuClick(e) {
        const trigger = e.target.closest('[data-level]');
        if (!trigger) return;

        const level = parseInt(trigger.getAttribute('data-level'));
        const container = trigger.closest('li') || trigger.closest('.column') || trigger.closest('.sub-child-column');
        if (!container) return;

        const nextMenu = container.querySelector(`[data-level="${level + 1}"]`);
        if (!nextMenu) return;

        // Récupère le label à afficher dans le breadcrumb
        const labelEl = trigger.querySelector('.sub-title, .sub-child-title') || trigger;
        const label = labelEl.textContent.trim();

        // 🧠 ➕ Ajoute au breadcrumb
        breadcrumbPath.push(label);
        updateBreadcrumb();

        // 🔒 Masquer le bouton cliqué lui-même
        trigger.style.display = 'none';

        // Cache les autres frères du menu
        const siblings = Array.from(container.parentElement.children).filter(sib => sib !== container);
        siblings.forEach(sib => sib.classList.add('hide_menu'));

        // Affiche le sous-menu
        nextMenu.classList.add('open');
        container.classList.remove('hide_menu');
        backButton.style.opacity = '1';

        // Sauvegarde l’état pour le retour
        menuStack.push({
            container: nextMenu,
            siblings: siblings,
            trigger: trigger // ← On garde aussi le trigger pour le réafficher au "back"
        });
    }

    // Quand on clique sur le bouton retour (flèche ←)
    backButton.addEventListener('click', function () {
    if (menuStack.length === 0) return;

    const lastLevel = menuStack.pop();

    // Enlève le dernier niveau du fil d'ariane
    breadcrumbPath.pop();
    updateBreadcrumb();

    // Ferme le sous-menu précédent
    lastLevel.container.classList.remove('open');

    // Réaffiche les frères qui avaient été masqués
    lastLevel.siblings.forEach(item => item.classList.remove('hide_menu'));

    // ✅ Réaffiche le lien de la catégorie cliquée précédemment
    if (lastLevel.trigger) {
        lastLevel.trigger.style.display = '';
    }

    // Si on est revenu au niveau racine, on cache le bouton retour et vide le breadcrumb
    if (menuStack.length === 0) {
        backButton.style.opacity = '0';
        breadcrumbEl.textContent = '';
    }
});

    // Met à jour le fil d’Ariane visuellement
    function updateBreadcrumb() {
        // Affiche la liste des éléments séparés par >
        breadcrumbEl.textContent = breadcrumbPath.join(' > ');
    }

    // Détecte tous les clics dans le menu pour ouvrir les sous-menus
    menuWrapper.addEventListener('click', handleMenuClick);
});
