<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class ReassuranceType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])
        
        ->add('title', TextType::class,[
            'label'    => 'Titre',
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "Ajouter un titre "
            ]
         ])


         ->add('sub_title', TextType::class,[
            'label'    => 'Sous titre',
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "Ajouter un sous-titre"
            ]
         ])
       
        ->add('image', FileType::class ,[
            'label' => 'Image de la Garanties ou du services',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])
        
        ->add('url', TextType::class ,[
                'label'    => 'url',
                'empty_data' => '',
            "attr"=>[
                "placeholder" => "url vers la page ou se trouve la garantie ou le service"
            ]
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

      public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter un encart personnalisé pour mettre en avant vos garanties, services après-vente ou engagements</br>
        - Activez ou désactivez l’affichage de cet encart de réassurance à l’aide du bouton "Activer la visibilité".</br>
        - Ajoutez un titre et un sous-titre pour présenter votre garantie ou service. Exemple : titre : Livraison gratuite.  sous-titre: livraison gratuite dès 50€</br>
        - Importez une image illustrative en cliquant sur "Choisir un(des) fichier(s)".</br>
        - Facultativement, indiquez une URL de redirection (ex. : page des conditions de garantie, CGV, SAV...).</br></br>

        Ces informations rassurent vos clients et améliorent la crédibilité de votre boutique.</br>
        Voici un lien pour accéder aux icônes : <a style="color:black; font-weight:700;" href="https://www.flaticon.com">ICI</a> exportez vos icônes en format 64px maximum pour garantir un affichage optimal
        ';
    }

}