<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Controllers\Admin;

use Symfony\Component\HttpFoundation\Request;
use PrestaShop\Module\PolarisPrestaTheme\Forms\CatalogueType;
use PrestaShop\Module\PolarisPrestaTheme\Forms\ProductType;
use PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTheme;
use PrestaShop\PrestaShop\Adapter\LegacyContext;
use PrestaShop\PrestaShop\Core\Addon\Theme\ThemeRepository;
use PrestaShop\PrestaShop\Core\Addon\Theme\ThemeManagerBuilder;


/**
 * AdminProductController
 * 
 * Contrôleur pour la configuration des pages Catalogue et Produit du thème PolarisPrestaTheme.
 */
class AdminProductController extends AdminFormController
{

     private ThemeRepository $themeRepository;
    private ThemeManagerBuilder $themeManagerBuilder;
    private LegacyContext $legacyContext;

    public function __construct(
        ThemeRepository $themeRepository,
        ThemeManagerBuilder $themeManagerBuilder,
        LegacyContext $legacyContext
    ) {
        $this->themeRepository = $themeRepository;
        $this->themeManagerBuilder = $themeManagerBuilder;
        $this->legacyContext = $legacyContext;
    }

    /**
     * ConfigurationCatalogueAction
     * 
     * Permet au client de configurer la page catalogue 
     * (filtre à gauche ou en haut, modification du layout du thème).
     * 
     * @param Request $request
     */
    public function ConfigurationCatalogueAction(Request $request)
    {
        $config = ConfigTheme::load();

        $context = $this->legacyContext->getContext();
        $theme = $this->themeRepository->getInstanceByName($context->shop->theme->getName());

        $pageLayouts = $theme->getPageLayouts();

        $config = ConfigTheme::load();
        if ($config->configCatalogue[0]->filter === 'filtreGauche') {
            $pageLayouts['category'] = 'layout-left-column';
        } elseif ($config->configCatalogue[0]->filter === 'filtreHaut') {
            $pageLayouts['category'] = 'layout-full-width';
        }

        $theme->setPageLayouts($pageLayouts);

        $themeManager = $this->themeManagerBuilder->build($context->shop);
        $themeManager->saveTheme($theme);

        return $this->CreateConfigurationForm(
            $request,
            CatalogueType::class,                                        // Type de formulaire pour le catalogue
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCatalogue',     // Classe de configuration
            '0',                                                          // ID de la configuration
            null,                                                         // Pas d'action spécifique
            'configCatalogue',                                            // Nom du tableau
            'admin_presta_catalogue',                                     // Redirection (évite de passer par AJAX)
            null,                                                         // Pas d'image à uploader
            'Configuration de la page listage des produits / catalogue'                          // Titre de la page
        );
    }

    /**
     * ConfigurationProductAction
     * 
     * Permet au client de configurer la page produit 
     * 
     * @param Request $request
     */
    public function ConfigurationProductAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            ProductType::class,                                          // Type de formulaire pour la page produit
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigProduct',       // Classe de configuration
            '0',                                                          // ID de la configuration
            null,                                                         // Pas d'action spécifique
            'configProduct',                                              // Nom du tableau
            null,                                                         // Pas de redirection spécifique
            null,                                                         // Pas d'image à uploader
            'Configuration de la fiche produit'                            // Titre de la page
        );
    }
}