document.addEventListener("DOMContentLoaded", function () {
    const carouselSlider = document.querySelector('.img-slider');
    const slides = document.querySelectorAll('.img-slider img');
    const dots = document.querySelectorAll('.dot');
    const prevBtn = document.querySelector('.prev'); // Bouton précédent
    const nextBtn = document.querySelector('.next'); // Bouton suivant

    slides.forEach((img) => {
        img.ondragstart = function() { return false; };
    });

    let counter = 0;
    let startX = 0;
    let endX = 0;
    let isDragging = false;
    const totalSlides = slides.length;
    let autoPlayInterval;
    const isAutoPlayEnabled = carouselSlider.classList.contains('autoplay');

    function updateSlider() {
        const size = slides[0].clientWidth;
        carouselSlider.style.transform = `translateX(${-size * counter}px)`;
        updateDots();
    }

    function updateDots() {
        dots.forEach(dot => dot.classList.remove('active'));
        dots[counter].classList.add('active');
    }

    function goToNextSlide() {
        counter = (counter + 1) % totalSlides;
        updateSlider();
    }

    function goToPrevSlide() {
        counter = (counter - 1 + totalSlides) % totalSlides;
        updateSlider();
    }

    function handleSwipe(start, end) {
        if (start > end) {
            goToNextSlide(); // Swipe vers la gauche → image suivante
        } else {
            goToPrevSlide(); // Swipe vers la droite → image précédente
        }
        restartAutoPlay();
    }

    // Auto-play functions
    function startAutoPlay() {
        if (isAutoPlayEnabled) {
            autoPlayInterval = setInterval(goToNextSlide, 5000);
        }
    }

    function stopAutoPlay() {
        clearInterval(autoPlayInterval);
    }

    function restartAutoPlay() {
        stopAutoPlay();
        startAutoPlay();
    }

    // SWIPE MOBILE
    carouselSlider.addEventListener('touchstart', (event) => {
        stopAutoPlay();
        startX = event.touches[0].clientX;
    }, { passive: true });

    carouselSlider.addEventListener('touchend', (event) => {
        endX = event.changedTouches[0].clientX;
        handleSwipe(startX, endX);
    }, { passive: true });

    // DRAG & DROP (Swipe Desktop)
    carouselSlider.addEventListener('mousedown', (event) => {
        stopAutoPlay();
        isDragging = true;
        startX = event.clientX;
    });

    document.addEventListener('mousemove', (event) => {
        if (isDragging) {
            endX = event.clientX;
        }
    });

    document.addEventListener('mouseup', (event) => {
        if (isDragging) {
            endX = event.clientX;
            handleSwipe(startX, endX);
            isDragging = false;
        }
    });

    // Boutons précédent/suivant
    if (prevBtn) prevBtn.addEventListener('click', () => {
        goToPrevSlide();
        restartAutoPlay();
    });

    if (nextBtn) nextBtn.addEventListener('click', () => {
        goToNextSlide();
        restartAutoPlay();
    });

    // Dots
    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            counter = index;
            updateSlider();
            restartAutoPlay();
        });
    });

    updateSlider();
    startAutoPlay(); // Démarre l'autoplay seulement si la classe .autoplay est présente
});
