<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class SliderParameterType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'label' => 'Activer la visibilité du slider',
            'required' => false,
        ])
        ->add('autoPlay',SwitchType::class, [
            'label' => 'Activer le mode autoplay sur le slider',
            'required' => false,
        ])

        ->add('background',SwitchType::class, [
            'label' => 'le slider integre le menu',
            'required' => false,
        ])

        ->add('width',SwitchType::class, [
            'label' => 'le slider s\'étend sur toute la largeur du site',
            'required' => false,
        ])

     
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet de configurer l’affichage d’un diaporama.</br>
        - Si vous ne souhaitez pas afficher le slider décochez l’option « Activer la visibilité du slider »</br>
        - Activer le mode autoplay pour que le slider défile automatiquement.</br>
        - Indiquer si le slider s’intègre dans le menu (fusion visuelle avec le menu principal).</br>
        - Choisir si le slider s’étend sur toute la largeur du site (plein écran ou contenu centré).
        ';
    }

}