<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use PrestaShopBundle\Form\Admin\Type\CustomContentType;
use Symfony\Component\Form\FormBuilderInterface;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

class ModuleConfGeneralType extends ThemeFormType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $cacheCfg = $this->module->loadCacheCfg();

        $builder
        ->add('title_sync', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => false,
                'title' => 'Système de cache intégré (FastCGI nginx cache)',
                'help' => 'La section suivante contrôle le cache intégré nginx.',
            ],
        ])

        ->add('cache_active', SwitchType::class, [
            'label'=>'Cache activé',
            'label_attr' => ['class' => 'label-mode'],
            // Indice pour l'utilisateur sur ce que fait le mode basique et le mode complet 
            'help' => 'Active ou désactive le cache.',
            'required' => false,
            'data' => $cacheCfg['ENABLED'],
        ])

        ->add('cache_auto_invalidate', SwitchType::class, [
            'label'=>'Purge automatique du cache',
            'label_attr' => ['class' => 'label-mode'],
            // Indice pour l'utilisateur sur ce que fait le mode basique et le mode complet 
            'help' => 'Invalider le cache pour un produit lorsque celui-ci est modifié.',
            'required' => false,
            'data' => $cacheCfg['INVALID_PRODUCT_CACHE'],
        ])        

        ->add('cache_duration', ChoiceType::class, [
            'label' => 'Durée de vie des pages du cache',
            'choices' => [
                '10 minutes' => '600',
                '20 minutes' => '1200',
                '30 minutes' => '1800',
                '1h' => '3600',
                '2h' => '7200',
                '4h' => '14400',
                '8h' => '28800',
                '12h' => '43200',
                '24h' => '86400',
            ],

            'expanded' => false,
            'required' => false,
            // placeholder false is important to avoid empty option in radio select despite required being false
            'placeholder' => false,
            'column_breaker' => true,
            //'help' => '', // should be set to enable help block
            'help' => 'Les pages plus anciennes seront regénérées.', // should be set to enable help block
            'data' => $cacheCfg['CACHE_MAX_AGE'],
        ])

        ->add('Enregistrer', SubmitType::class, [
            'attr' => ['class' => 'btn-form-valid btn-primary']
        ]);        
        
    }

}