<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class HighlightType extends AbstractType{
    
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])
        
        ->add('title', TextType::class,[
            'label'    => 'Titre',
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "Ajouter un titre"
            ]
         ])


         ->add('subTitle', TextType::class,[
            'label'    => 'sous-titre',
            'empty_data' => '',
            'required' => false,
            "attr"=>[
                "placeholder" => "Ajouter sous titre "
            ]
         ])
       
        ->add('image', FileType::class ,[
            'label' => 'Image de la catégorie',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])

        ->add('url', TextType::class ,[
                'label'    => 'url',
                'empty_data' => '',
              "attr"=>[
                "placeholder" => "Url de la page souhaitée"
            ]
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

     public static function getIntro(): ?string
    {
        return 'Cette page vous permet de gérer l\'affichage des images mises en avant dans votre boutique.</br>
        - Activez ou désactivez l\'affichage du bloc via l\'interrupteur de visibilité.</br>
        - Renseignez un titre (facultatif) et un sous-titre (facultatif) pour accompagner l’image</br>
        - Ajoutez une image représentative en cliquant sur "Choisir un(des) fichier(s)"</br>
        - Facultativement, indiquez une URL de redirection : si elle est renseignée, le clic sur l’image redirigera vos clients vers cette adresse.
        - Une fois toutes les informations saisies, cliquez sur "Enregistrer" pour valider vos modifications.
        ';
    }

}