<?php

declare(strict_types=1);

namespace PrestaShop\Module\PolarisPrestaTheme\Config;
use Manufacturer;
use Link;


class ConfigBrand 
{
    /**
     * Visibilité du bloc
     *
     * @var bool
     */
    public $isVisible = true;


    /**
     * Visibilité du bouton
     *
     * @var bool
     */
    public $btn = false;


    /**
     * titre de la section 
     *
     * @var string
     */
    public $title = '';

    /**
     * Marques sélectionnées (enrichies avec id, name, url, img)
     *
     * @var array
     */
    public $selected_brands = [];


    /**
     * selection de la disposition des marques 
     *
     * @var string
     */
    public $style = '';


      /**
     * Enrichit $selected_brands avec les données complètes
     */
    public function enrich(): void
    {
    

        $link = new Link(); //utilisé pour générer les URLs des marques
        $id_lang = \Context::getContext()->language->id;// Récupère l'ID de la langue courante
        $enriched = [];// Tableau pour stocker les marques enrichies

        foreach ($this->selected_brands as $id) {
            $manufacturer = new Manufacturer((int) $id, $id_lang);// Crée une instance de Manufacturer avec l'ID et la langue courante

            $enriched[] = [
                'id' => (int) $id,// ID de la marque
                'name' => $manufacturer->name,// Nom de la marque
                'url' => $link->getManufacturerLink($manufacturer),// URL de la marque
                'img' => _PS_BASE_URL_._THEME_MANU_DIR_ . $id . '.jpg', // Chemin de l'image de la marque
            ];
        }

        $this->selected_brands = $enriched;// Met à jour le tableau selected_brands avec les marques enrichies

       
    }


}
