<?php 
namespace PrestaShop\Module\PolarisPrestaTheme\Controllers\Admin;

use Db;
use Exception;
use Symfony\Component\HttpFoundation\JsonResponse;

class ContactCustomerAdminController extends  AdminFormController
{

    //fonction qui envoi les mails de security au client 
    public function ajaxProcessSendSecurityAlertAction():JsonResponse
    {
        $this->CustomerBulkMailSend('security_alert', 'Alerte de sécurité'); 

         return new JsonResponse(['success' => true, 'message' => '']);
    } 
    

    /**
     * CustomerBulkMailSend
     *
     * Envoi un mail a tous les clients
     * 
     * @param string $template nom du fichier de template sans extension
     * @param string $sujet sujet du mail 
     * 
     */
    public function CustomerBulkMailSend(string $template , string $sujet)
    {
        // on charga les infos clients 
        $db = \Db::getInstance();

        $result = $db->executeS(" SELECT email, lastname , firstname FROM `"._DB_PREFIX_."customer` ");

        if($result === false)
            throw new \Exception("erreur au retrait des informations clients : " . $db->getMsgError());

        

        foreach ($result as $customerInfo) {
            try{
            // Envoi d'email à chaque client
            $this->sendEmailToClient($customerInfo , $template, $sujet);
            set_time_limit(20); // Pas de limite de temps pour le processus
            }catch(Exception $e){
                \PrestaShopLogger::addLog(sprintf("Erreur à l\'envoi du mail '%s' : %s", $customerInfo['email'],$e->getMessage()),3, null, 'security_alert');
            }
                
        }

    }

    /**
     * sendEmailToClient
     *
     * Envoi un mail a un client d'apres ses informations
     * 
     * @param array $customerInfo map: email, firstname, lastname
     * @param string $template nom du fichier de template sans extension
     * @param string $sujet sujet du mail 
     * 
     */
    private function sendEmailToClient(array $customerInfo , string $template , string $sujet)
    {
        \Mail::Send(
            (int)(\Configuration::get('PS_LANG_DEFAULT')),
            $template,
            $sujet,
            [
                '{email}' => \Configuration::get('PS_SHOP_EMAIL'),
                '{message}' => 'Attention : Il y a une alerte de sécurité !',
                '{firstname}' => $customerInfo['firstname'],
                '{lastname}' => $customerInfo['lastname'],
            ],
            $customerInfo['email'],
            $customerInfo['firstname'] . " " . $customerInfo['lastname'],
            NULL,
            NULL,
            NULL,
            NULL,
            _PS_MODULE_DIR_ . 'polarisprestatheme/mails/fr/'
        );
    }



}