<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Controllers\Admin;

use Symfony\Component\HttpFoundation\Request;

use PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTheme;
use PrestaShop\Module\PolarisPrestaTheme\Forms\{ResauxType,CategoryType,CategoryParameterType,SliderType,SliderParameterType,NewProductType,SaleProductType,AboutType,ReassuranceType,LivraisonType,TopBandeauType,TopBandeauParameterType,HighlightType,BrandType};
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * AdminHomeBlocksController
 * 
 * Contrôleur pour la configuration des differents blocks present sur la page d'accueil.
 * Permet de gérer les réseaux sociaux, les catégories, les sliders, les nouveaux produits, les produits en promotion, la section "À propos",
 * les éléments de rassurance, la livraison, le bandeau supérieur et les image à mettre en avant.
 * 
 */
class AdminHomeBlocksController extends AdminFormController
{

    /**
     * ConfigurationResauxAction
     * 
     * Permet au client de configurer les logos des réseaux sociaux
     * 
     * @param Request $request
     * @param int $id L'ID de la configuration des réseaux sociaux
     * @param string $action Action à effectuer (ajouter, modifier, supprimer)
     */
    public function ConfigurationResauxAction(Request $request, int $id, $action)
    {
        return $this->CreateConfigurationForm(
            $request,
            ResauxType::class, // Type de formulaire pour les réseaux sociaux
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigResaux', // Classe de configuration
            $id, // ID de la configuration
            $action, // Action à effectuer (ajout, modification, suppression)
            'configResaux', // Nom du tableau de configuration
            'admin_presta_show_resaux', // Redirection après traitement
            true, // L'image doit être uploadée
            'Configuration des liens vers les réseaux sociaux' // Titre de la page
        );
    }


    /**
     * showResauxAction
     * 
     * Affiche les logos des réseaux sociaux configurés
     * 
     */
    public function showResauxAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les réseaux sociaux configurés
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_resaux.html.twig', [
            'resaux' => $config->configResaux
        ]);
    }


    /**
     * ConfigurationCategoryAction
     * 
     * Permet au client d'ajouter des catégories avec des images personnalisées sur la page d'accueil
     * 
     * @param Request $request
     * @param int $id L'ID de la catégorie
     * @param string $action Action à effectuer (ajouter, modifier, supprimer)
     */
    public function ConfigurationCategoryAction(Request $request, int $id, $action)
    {
        return $this->CreateConfigurationForm(
            $request,
            CategoryType::class, // Type de formulaire pour les catégories
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCategory', // Classe de configuration
            $id, // ID de la catégorie
            $action, // Action à effectuer
            'configCategory', // Nom du tableau
            'admin_presta_show_category', // Redirection après traitement
            true, // L'image doit être uploadée
            'Configuration des visuels par catégorie' // Titre de la page
        );
    }

    /**
     * ParameterCategoryAction
     * 
     * Permet au client de configurer les paramètres des catégories (changer le style)
     * 
     * @param Request $request
     */
    public function ParameterCategoryAction(Request $request){
        
        return $this->CreateConfigurationForm(
            $request,
            CategoryParameterType::class, // Type de formulaire pour le footer
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCategoryParameter', // Classe de configuration
            '0',  // ID de la configuration
            null, // Pas d'action spécifique
            'configCategoryParameter', // Nom du tableau
            'admin_presta_show_category',  // Pas de redirection spécifique
            null,   // Pas d'image à uploader
            'Choississez le Visuels du bloc categorie' // Titre de la page
        );
    }

    /**
     * ShowCategoryAction
     * 
     * Affiche les catégories ajoutées à la configuration
     * 
     */
    public function ShowCategoryAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les catégories configurées
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_category.html.twig', [
            'categories' => $config->configCategory
        ]);
    }


    /**
     * ConfigurationSliderAction
     * 
     * Permet au client de parameterer le slider (autolay , fullscreen etc ...)
     * 
     * @param Request $request
     */
    public function ParameterSliderAction(Request $request){
        
        return $this->CreateConfigurationForm(
            $request,
            SliderParameterType::class, // Type de formulaire pour le footer
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigSliderParameter', // Classe de configuration
            '0',  // ID de la configuration
            null, // Pas d'action spécifique
            'configSliderParameter', // Nom du tableau
            'admin_presta_show_slider',  // Pas de redirection spécifique
            null,   // Pas d'image à uploader
            'Choississez les paramètres du Diaporama' // Titre de la page
        );
    }


    /**
     * ShowSliderAction
     * 
     * Affiche les sliders configurés
     * 
     */
    public function ShowSliderAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les sliders configurés
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_slider.html.twig', [
            'sliders' => $config->configSlider,
        ]);
    }

    /**
     * ConfigurationSliderAction
     * 
     * Permet au client d'ajouter ou de modifier un slider
     * 
     * @param Request $request
     * @param int $id L'ID du slider
     * @param string $action Action à effectuer
     */
    public function ConfigurationSliderAction(Request $request, int $id, $action)
    {
        return $this->CreateConfigurationForm(
            $request,
            SliderType::class, // Type de formulaire pour les sliders
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigSlider', // Classe de configuration
            $id, // ID du slider
            $action, // Action à effectuer
            'configSlider', // Nom du tableau
            'admin_presta_show_slider', // Redirection après traitement
            true, // L'image doit être uploadée
            'Configuration du Diaporama' // Titre de la page
        );
    }

    /**
     * ConfigurationNouveauProduitAction
     * 
     * Permet au client de configurer le block nouveau produit
     * 
     * @param Request $request
     */
    public function ConfigurationNouveauProduitAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            NewProductType::class, // Type de formulaire pour un nouveau produit
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigNouveauProduit', // Classe de configuration
            '0', // ID du produit
            null, // Pas d'action spécifique
            'configNouveauProduit', // Nom du tableau
            null, // Pas de redirection spécifique
            null, // Pas d'image à uploader
            'Configuration des nouveaux produits' // Titre de la page
        );
    }

    /**
     * ConfigurationPromotionProduitAction
     * 
     * Permet au client de configurer le block produit en promotion
     * 
     * @param Request $request
     */
    public function ConfigurationPromotionProduitAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            SaleProductType::class, // Type de formulaire pour un produit en promotion
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigPromotionProduit', // Classe de configuration
            '0', // ID du produit
            null, // Pas d'action spécifique
            'configPromotionProduit', // Nom du tableau
            null, // Pas de redirection spécifique
            null, // Pas d'image à uploader
            'Configuration des produits en promotion' // Titre de la page
        );
    }

    /**
     * ConfigurationAboutAction
     * 
     * Permet au client de configurer la section "À propos"
     * 
     * @param Request $request
     */
    public function ConfigurationAboutAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            AboutType::class, // Type de formulaire pour la section "À propos"
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigAbout', // Classe de configuration
            '0', // ID de la configuration
            null, // Pas d'action spécifique
            'configAbout', // Nom du tableau
            'admin_presta_about', // Pas de redirection spécifique
            true, // L'image doit être uploadée
            'Configuration de la présentation de votre boutique' // Titre de la page
        );
    }

    /**
     * ShowReassuranceAction
     * 
     * Affiche les informations de rassurance configurées
     * 
     */
    public function ShowReassuranceAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les rassurances configurées
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_reassurance.html.twig', [
            'reassurances' => $config->configReassurance
        ]);
    }

    /**
     * ConfigurationReassuranceAction
     * 
     * Permet au client de configurer les éléments de rassurance
     * 
     * @param Request $request
     * @param int $id L'ID de l'élément de rassurance
     * @param string $action Action à effectuer
     */
    public function ConfigurationReassuranceAction(Request $request, int $id, $action)
    {
        return $this->CreateConfigurationForm(
            $request,
            ReassuranceType::class, // Type de formulaire pour la rassurance
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigReassurance', // Classe de configuration
            $id, // ID de la rassurance
            $action, // Action à effectuer
            'configReassurance', // Nom du tableau
            'admin_presta_show_reassurance', // Redirection après traitement
            true, // L'image doit être uploadée
            'Configuration des éléments de Garanties et de services' // Titre de la page
        );
    }

    /**
     * ConfigurationLivraisonAction
     * 
     * Permet au client de configurer la section de livraison
     * 
     * @param Request $request
     */
    public function ConfigurationLivraisonAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            LivraisonType::class, // Type de formulaire pour la livraison
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigLivraison', // Classe de configuration
            '0', // ID de la configuration
            null, // Pas d'action spécifique
            'configLivraison', // Nom du tableau
            null, // Pas de redirection spécifique
            null, // Pas d'image à uploader
            'Configuration des informations de livraison' // Titre de la page
        );
    }


    
    /**
     * ConfigurationTopBandeauAction
     * 
     * Permet au client de configurer le bandeau supérieur
     * 
     * @param Request $request
     * @param int $id L'ID du bandeau
     * @param string $action Action à effectuer (ajouter, modifier, supprimer)
     */
    public function ConfigurationTopBandeauAction(Request $request, int $id, $action){
        return $this->CreateConfigurationForm(
            $request,
            TopBandeauType::class, // Type de formulaire pour la rassurance
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTopBandeau', // Classe de configuration
            $id, // ID de la rassurance
            $action, // Action à effectuer
            'configTopBandeau', // Nom du tableau
            'admin_presta_show_bandeau', // Redirection après traitement
            true, // L'image doit être uploadée
            'Configuration des éléments du bandeau supérieur' // Titre de la page
        );
    }


    /**
     * ShowTopBandeauAction
     * 
     * Affiche les éléments du bandeau 
     * 
     */
    public function ShowTopBandeauAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les rassurances configurées
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_top_bandeau.html.twig', [
            'bandeaux' => $config->configTopBandeau
        ]);
    }

    /**
     * ParameterTopBandeauAction
     * 
     * Permet au client de configurer les paramètres du bandeau supérieur(couleur,visibilité etc ...)
     * 
     * @param Request $request
     */
    public function ParameterTopBandeauAction(Request $request){
        
        return $this->CreateConfigurationForm(
            $request,
            TopBandeauParameterType::class, // Type de formulaire pour le footer
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTopBandeauParameter', // Classe de configuration
            '0',  // ID de la configuration
            null, // Pas d'action spécifique
            'configTopBandeauParameter', // Nom du tableau
            'admin_presta_show_bandeau',  // Pas de redirection spécifique
            null,   // Pas d'image à uploader
            'Choississez les paramètres du bandeau supérieur' // Titre de la page
        );
    }


    /**
     * ConfigurationHighlightAction
     * 
     * Permet au client de configurer l'image à mettre en avant
     * 
     * @param Request $request
     * @param int $id L'ID de la configuration
     * @param string $action Action à effectuer (ajouter, modifier, supprimer)
     */
    public function ConfigurationHighlightAction(Request $request, int $id, $action){
        return $this->CreateConfigurationForm(
            $request,
            HighlightType::class, // Type de formulaire pour le catalogue
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigHighlight', // Classe de configuration
            $id, // ID de la configuration
            $action, // Pas d'action spécifique
            'configHighlight', // Nom du tableau
            'admin_presta_show_highlight', // Pas de redirection spécifique
            true, // Pas d'image à uploader
            'Configuration des images à mettre en avant' // Titre de la page
        );
    }

    /**
     * ShowHighlightAction
     * 
     * Affiche les images à mettre en avant 
     * 
     */
    public function ShowHighlightAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les rassurances configurées
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_highlight.html.twig', [
            'highlights' => $config->configHighlight
        ]);
    }

    /**
     * ConfigurationBrandAction
     * 
     * Permet au client de configurer le bloc marque (marque a mettre en avant , slider etc ...)
     * 
     * @param Request $request
     */
    public function ConfigurationBrandAction(Request $request){

        return $this->CreateConfigurationForm(
            $request,
            BrandType::class, // Type de formulaire pour le catalogue
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigBrand', // Classe de configuration
            '0', // ID de la configuration
            null, // Pas d'action spécifique
            'configBrand', // Nom du tableau
            null, // Pas de redirection spécifique
            null, // Pas d'image à uploader
            'Configuration du bloc Marques partenaires' // Titre de la page
        );
    }

  
    /**
     * ConfigurationBlockPositionAction
     * 
     * Permet au client de configurer la position des blocs sur la page d'accueil
     * 
     */
    public function ConfigurationBlockPositionAction(Request $request){
        
        $config = ConfigTheme::load();

        // Enregistrement AJAX
        if ($request->isXmlHttpRequest()) {
            $newOrder = $request->get('order');
            $config->configBlockPosition = $newOrder;
            $config->save();
            return new JsonResponse(['success' => true]);
        }
    
        // Blocs disponibles par défaut
        $defaultBlocks = [
            'category' => 'Block Catégories',
            'new_products' => 'Block Nouveautés',
            'about' => ' Block À propos',
            'sale_products' => 'Block Promotions',
            'highlight' => 'Block Image à mettre en avant',
            'brand' => 'Block Marques',
        ];
    
        $savedOrder = $config->configBlockPosition ?: array_keys($defaultBlocks);
    
        $blocks = [];
        foreach ($savedOrder as $key) {
            if (isset($defaultBlocks[$key])) {
                $blocks[] = ['id' => $key, 'label' => $defaultBlocks[$key]];
            }
        }
    
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_block_position.html.twig', [
            'blocks' => $blocks,
            'ajax_url' => $this->generateUrl('admin_presta_position'),
        ]);
    }

   
     
}