<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Controllers\Admin;

use Symfony\Component\HttpFoundation\Request;
use PrestaShop\Module\PolarisPrestaTheme\Forms\{GeneralType, TrackingType,HeaderType, FooterType, PopUpType,CssType,StoreType};
use PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTheme;

/**
 * AdminGeneralController
 * 
 * Contrôleur pour la configuration genérale du thème PolarisPrestaTheme.
 * Permet de gérer les paramètres généraux, le header, le footer , varibale css.
 */
class AdminGeneralController extends AdminFormController
{
    /**
     * ConfigurationAction
     * 
     * Permet au client de choisir un thème parmi les 3 disponibles , choisir la couleur principale et la couleur secondaire , et les polices à utiliser.
     * 
     * 
     * @param Request $request
     */
    public function ConfigurationGeneralAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            GeneralType::class,                                          // Type de formulaire
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigGeneral',       // Classe de configuration
            '0',                                                         // ID de la configuration
            null,                                                        // Pas d'action spécifique
            'configGeneral',                                             // Nom du tableau
            'admin_presta_general',                                      // Pas de redirection spécifique
            null,                                                        // Pas d'image à uploader
            'Configuration général du theme'                             // Titre de la page
        );
    }

    /**
     * ConfigurationHeaderAction
     * 
     * Permet au client de configurer un header parmi les 3 disponibles
     * 
     * @param Request $request
     */
    public function ConfigurationHeaderAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            HeaderType::class,                                           // Type de formulaire pour le header
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigHeader',        // Classe de configuration
            '0',                                                         // ID de la configuration
            null,                                                        // Pas d'action spécifique
            'configHeader',                                              // Nom du tableau
            null,                                                        // Pas de redirection spécifique
            null,                                                        // Pas d'image à uploader
            'Choississez une en-tete'                                    // Titre de la page
        );
    }

    /**
     * ConfigurationFooterAction
     * 
     * Permet au client de configurer un footer parmi les 3 disponibles
     * 
     * @param Request $request
     */
    public function ConfigurationFooterAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            FooterType::class,                                           // Type de formulaire pour le footer
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigFooter',        // Classe de configuration
            '0',                                                         // ID de la configuration
            null,                                                        // Pas d'action spécifique
            'configFooter',                                              // Nom du tableau
            null,                                                        // Pas de redirection spécifique
            null,                                                        // Pas d'image à uploader
            'Choississez un pied de page'                                // Titre de la page
        );
    }

    /**
     * ConfigurationGoogleTagManagerAction
     * 
     * @param Request $request
     */
    public function ConfigurationGoogleTagManagerAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            TrackingType::class,                                           // Type de formulaire
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTracking',        // Classe de configuration
            '0',                                                         // ID de la configuration
            null,                                                        // Pas d'action spécifique
            'configTracking',                                              // Nom du tableau
            null,                                                        // Pas de redirection spécifique
            null,                                                        // Pas d'image à uploader
            'Configuration du suivi de votre site internet'              // Titre de la page
        );
    }

    public function ConfigurationPopUpAction(Request $request)
    {
        return $this->CreateConfigurationForm(
            $request,
            PopUpType::class,                                           // Type de formulaire
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigPopUp',        // Classe de configuration
            '0',                                                         // ID de la configuration
            null,                                                        // Pas d'action spécifique
            'configPopUp',                                              // Nom du tableau
            'admin_presta_popup',                                      // Pas de redirection spécifique
            true,                                                        // Pas d'image à uploader
            'Configuration du pop-up'                                   // Titre de la page
        );
    }


    public function ConfigurationCssAction(Request $request){
        return $this->CreateConfigurationForm(
            $request,
            CssType::class,                                               // Type de formulaire
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCss',           // Classe de configuration
            '0',                                                         // ID de la configuration
            'null',                                                   // Action spécifique pour sauvegarder le CSS
            'configCss',                                                 // Nom du tableau
            'admin_presta_css',                                          // Redirection spécifique après sauvegarde
            false,                                                       // Pas d'image à uploader
            'Personnalisation du CSS'                                    // Titre de la page
        );
    }

    public function ConfigurationStoreAction(Request $request ,$id , $action)
    {
        return $this->CreateConfigurationForm(
            $request,
            StoreType::class,                                             // Type de formulaire
            '\PrestaShop\Module\PolarisPrestaTheme\Config\ConfigStore',         // Classe de configuration
            $id,                                                         // ID de la configuration
            $action,                                                        // Pas d'action spécifique
            'configStore',                                              // Nom du tableau
            'admin_presta_show_store',                                      // Pas de redirection spécifique
            true,                                                        // Pas d'image à uploader
            'Sélection du magasin'                                      // Titre de la page
        );
    }


    /**
     * showStoreAction
     * 
     * Affichage des magasins configurés
     * 
     */
    public function showStoreAction()
    {
        // Chargement de la configuration
        $config = ConfigTheme::load();

        // Retourne la vue avec les magasins configurés
        return $this->render('@Modules/polarisprestatheme/views/templates/admin/show_store.html.twig', [
            'stores' => $config->configStore
        ]);
    }
    
}
