<?php 
/**
 * 
 */

declare(strict_types=1);

namespace PrestaShop\Module\PolarisPrestaTheme\Config;

/**
 *  parametrage categorie mise en avant
 */
class ConfigMenuMedia{


     /**
     * Liste des medias à injecter
     *
     * @var array
     */
    public $medias = [];

    /**
     * visibilité du bloc 
     *
     * @var bool
     */
    public $isVisible = true;

    /**
     * Injecte directement une colonne de media dans le bon parent
    */
    public function injectInto(array &$parents, ?int $columnIndex = null , $action): void
    {
         
        $config = ConfigTheme::load();

            // On parcourt tous les menus parents pour trouver celui correspondant à l'injection
            foreach ($parents as &$parent) {
                // Vérifie si le parent est celui ciblé par l'injection
                if ($parent->menu['id'] == $this->medias[0]['parent_id']) {


                    if($action === 'delete'){
                        // Si l'action est de supprimer, on supprime la colonne
                        if ($columnIndex !== null && isset($parent->menu['columns'][$columnIndex])) {
                            unset($parent->menu['columns'][$columnIndex]);
                        }
                        // On sort de la boucle après la suppression
                        break;
                    }

                    if($action ==='edit'){
                        $column = $this->medias;
                        if ($columnIndex !== null && $columnIndex !== -1  && isset($parent->menu['columns'][$columnIndex])) {
                            $oldColumn = $parent->menu['columns'][$columnIndex];
                            $oldSourceIndex = $oldColumn['sourceIndex'] ?? 0;
                            // Édition de la colonne à l'index spécifié
                            $parent->menu['columns'][$columnIndex] = [
                                'columnIndex' => $columnIndex,
                                'blocks' => $column,
                                'type' => 'media',
                                'sourceIndex' => $oldSourceIndex,
                                'isVisible' => $this->isVisible
                            ];
                        }
                        break;
                    }

                    if($action === 'add'){
                        $column = $this->medias;
                        $existingIndexes = array_keys($parent->menu['columns'] ?? []);
                        $existingIndexes = array_map('intval', $existingIndexes);
                        $nextIndex = empty($existingIndexes) ? 1 : max($existingIndexes) + 1;

                        $parent->menu['columns'][$nextIndex] = [
                            'columnIndex' => $nextIndex,
                            'blocks' => $column,
                            'type' => 'media',
                            'sourceIndex' => count($config->configMenuMedia),
                            'isVisible' => $this->isVisible

                        ];
                        // Une fois la colonne injectée, on sort de la boucle
                        break;

                    }
                  
                  
                }
            }
        


    }


} 