document.addEventListener('DOMContentLoaded', function () {
  const COOKIE_NAME = 'popup_newsletter';
  const HOURS_VALID = 12;
  const popup   = document.querySelector('#popup-newsletter');                 
  const overlay = document.querySelector('.overlay');     
  const closeBtn = document.querySelector('.close-popup');    
  const submitPopup = document.querySelector('.btn-submit-newsletter');   
  const SHOW_DELAY = 1500; // délai en millisecondes (ici 3 secondes)

  function setCookie(name, value, hours) {
    const d = new Date();
    d.setTime(d.getTime() + hours * 60 * 60 * 1000);
    document.cookie = encodeURIComponent(name) + '=' + encodeURIComponent(value) +
      ';expires=' + d.toUTCString() + ';path=/;SameSite=Lax';
  }

  function getCookie(name) {
    const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
    return match ? decodeURIComponent(match[2]) : null;
  }

  if (!getCookie(COOKIE_NAME)) {
    popup.style.display = 'block';
    overlay.style.display = 'block';
    setTimeout(function () {
      document.body.classList.add('no-scroll');
      popup.classList.add('show'); // ajout de la classe animée
      overlay.classList.add('show');
      setCookie(COOKIE_NAME, '1', HOURS_VALID);
    }, SHOW_DELAY);
  } else {
    popup.style.display = 'none';
    overlay.style.display = 'none';
  }

  closeBtn.addEventListener('click', function () {
    popup.classList.remove('show'); 
    overlay.classList.remove('show');
    setTimeout(function () {
      document.body.classList.remove('no-scroll');
      popup.style.display = 'none';
      overlay.style.display = 'none';
    }, 300); // délai pour permettre à l'animation de se terminer
  });

  submitPopup.addEventListener('click', function () {
    setTimeout(function () {
      document.body.classList.remove('no-scroll');
      popup.classList.remove('show'); 
      overlay.classList.remove('show');
        setTimeout(function () {
          popup.style.display = 'none';
          overlay.style.display = 'none';
        }, 300); 
    }, 2000); // délai pour permettre à l'animation de se terminer

  });



});
