
$(document).ready(function () {
    
    if ($('.toggle-visibility')){
        $('.toggle-visibility').on('click', function (e) {
            e.preventDefault();
            const $icon = $(this).find('.material-icons');

            $.ajax({
                url: $(this).data('url'),
                method: 'POST',
                data: { 
                    id: $(this).data('id'),
                    objet: $(this).data('objet'),
                    column: $(this).data('column'),
                },
                dataType: 'json',            
            }) 
            .fail(function (data) {
                alert('Erreur : ' + (data.responseJSON.message || 'Échec de l’opération'));
            }
            )
            .done(function (data) {
                if (data.success) {
                    $icon.text(data.new_state ? 'check' : 'close');
                    $icon.css('color', data.new_state ? 'green' : 'red');
                } else {
                    alert('Erreur : ' + (data.message || 'Échec de l’opération'));
                }
            });

        });
    }
     
    
    const fontTitleChoice = document.querySelector('#general_fontTitle')
    const fontTextChoice = document.querySelector('#general_fontText')
    const help = document.querySelectorAll('small');

    if (fontTitleChoice) {
        help[0].style.fontFamily = fontTitleChoice.value;
        fontTitleChoice.addEventListener('change', function() {
            help[0].style.fontFamily = this.value;
        });
    }

    if (fontTextChoice) {
        help[1].style.fontFamily = fontTextChoice.value;
        fontTextChoice.addEventListener('change', function() {
            help[1].style.fontFamily = this.value;
        });
    }

});
