<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class PopUpType extends AbstractType{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
           ->add('isVisible', SwitchType::class, [
                'label' => 'Activer',
                'required' => false,
            ])

            ->add('title', TextType::class,[
                'label'    => 'Titre',
                'empty_data' => '',
                "attr"=>[
                    "placeholder" => "Ajouter un titre au popup"
                ]
            ])

            ->add('subTitle', TextType::class,[
                'label'    => 'sous-titre',
                'required' => false,
                'empty_data' => '',
                "attr"=>[
                    "placeholder" => "sous titre deu popup"
                ]
            ])

            ->add('codeReduction', textType::class, [
                'label' => 'Code de réduction à appliquer à l\'inscription',
                'required' => false,
                'attr' => [
                    'placeholder' => 'Entrez le code de réduction',
                ],
            ])

           ->add('image', FileType::class ,[
            'label' => 'Image de présentation',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])

            ->add('save', SubmitType::class, [
                'label' => 'Enregistrer',
            ]);
    }


      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

        public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser l’affichage du pop up Newsletter</br>
        - Afficher ou masquer le pop up</br>
        - Renseignez un titre pour le pop up. Le sous-titre est facultatif et peut être laissé vide.</br>
        - ajouter une image au popup facultatif et peut être laissé vide.</br>
        - ajouter un code de réduction à l\'inscription facultatif et peut être laissé vide.<br>
        ';
    }

     
}