<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;


class FooterType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
        ->add('footer', ChoiceType::class, [
            'choices' => [
                'Footer 1' => 'footer1',
                'Footer 2' => 'footer2',
                'Footer 3' => 'footer3',
            ],
            'label' => 'Choisissez un style de pied de page ',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],
            'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'footer1':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/footer1.png" alt="Footer 1" />';
                    case 'footer2':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/footer1.png" alt="Footer 1" />';
                    case 'footer3':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/footer1.png" alt="Footer 1" />';
                }
            },
           
            'required' => true,
        ])

            ->add('background', ColorType::class, [
                'label' => 'Couleur de fond',
                'attr' => [
                    'class' => 'color-picker',
                ],
            ])

            ->add('color', ColorType::class, [
                'label' => 'Couleur du texte',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])

            ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                    'data-hex' => 'true'
                ],
            ])
        ;
       
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet de configurer le pied de page</br>
        - Choisissez un style parmi les modèles proposés en cliquant simplement sur le visuel souhaité.</br>
        - Définissez la couleurs de fond du pied de page.</br>
        - Définissez la couleurs du texte du pied de page.</br>
        - Une fois tous les champs remplis, cliquez sur "Enregistrer" pour enregistrer les modifications.
        ';
    }

}