<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;



class CatalogueType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('color',SwitchType::class, [
            'label'    => 'Afficher les couleurs sur les miniatures',
            'required' => false,
            
        ])

        ->add('size',SwitchType::class, [
            'label'    => 'Afficher les tailles sur les miniatures',
            'required' => false,
        ])

        ->add('show',SwitchType::class, [
            'label'    => 'Afficher l\'aperçu rapide du produit sur la miniature',
            'required' => false,   
        ])

        ->add('colProduct',IntegerType::class, [
            'label'    => 'Produits à afficher par colone',
            'attr' => ['min' => 3, 'max' => 4],
              "attr"=>[
                "placeholder" => "Ajouter un nombre de produits à afficher par colone (entre 3 et 4)"
            ]
         ])

        ->add('pageProduct',IntegerType::class, [
            'label'    => 'Produits à afficher par page',
            'attr' => ['min' => 9, 'max' => 50],
            "attr"=>[
                "placeholder" => "Ajouter un nombre de produits à afficher par page (entre 9 et 50)"
            ]
         ])



        ->add('filter', ChoiceType::class, [
            'choices' => [
                'Filtre a gauche' => 'filtreGauche',
                'Filtre en haut' => 'filtreHaut',
            ],
            'label' => 'Choisissez la disposition du filtre',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],
            'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'filtreGauche':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/filter-gauche.jpeg" alt="Filtre gauche" />';
                    case 'filtreHaut':
                        return '<img src="' . $baseUri . 'modules/polarisprestatheme/img/filter-bas.jpeg" alt="Filtre bas" />';
                }
            },
           
            'required' => true,
        ])
            
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])

        ;
       
    }

     public static function getIntro(): ?string
    {
        return 'Cette page permet de configurer l’affichage du listing produit</br>
        - Vous pouvez choisir d’afficher ou non des pastilles de couleur sur les miniatures*<br>
        - Vous pouvez activer ou non l’affichage des tailles disponibles directement sur les miniatures*<br>
        - Vous pouvez activer ou non la fonction aperçu rapide sur les miniatures* (voir les détails sans ouvrir la fiche produit). <br>
        - Vous pouvez définir le nombre de produits par colonne. Recommandation : 3 produits par ligne lorsque le filtre est à gauche, 4 produits si le filtre est en haut.<br>
        - Vous pouvez également définir le nombre de produits par page<br><br>

        *miniature : petite image qui représente visuellement l\'article dans le listing des produits.<br>
        ';
    }

}