<?php

namespace PrestaShop\Module\PolarisPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

use PrestaShopBundle\Form\Admin\Type\FormattedTextareaType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class AboutType  extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'label' => 'Activer la visibilité',
            'required' => false,
        ])

        ->add('texte', FormattedTextareaType::class, [
            'label' => 'texte de présentation',
            'attr' => [
                'class' => 'prestashop-textarea', // Ajout d'une classe pour l'initialisation de TinyMCE
            ],
            'empty_data' => '',
            'required' => false,
        ])
       
        ->add('image', FileType::class ,[
            'label' => 'Image de présentation',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])
        
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

    public static function getIntro(): ?string
    {
        return 'Ce bloc permet de configurer l’affichage de la section de présentation de la boutique.<br>
        - Vous pouvez ajouter un texte de présentation, avec mise en forme via l’éditeur intégré.<br> 
        - Vous pouvez également ajouter une image illustrant la boutique.br>';
    }

}