<?php 


declare(strict_types=1);

namespace PrestaShop\Module\PolarisPrestaTheme\Config;


use Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor;
use Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor;
use Symfony\Component\PropertyInfo\PropertyInfoExtractor;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ArrayDenormalizer;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

/**
 * [obj parametrage theme]
 */
class ConfigTheme {

    /**
     * Chemin de stockage par défaut de la configuration du thème
     */
    const themeConfigFile = _PS_ROOT_DIR_ . '/themes/config2.json';

    /**
     * description des themes 
     *
     * @var ConfigGeneral[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigGenral>
     */
    public $configGeneral = [
        [
            "theme" => "theme1",
            "primary" => "#f31212",
            "secondary" => "#000000",
            "fontTitle" => "lato",
            "fontText" => "lato"
        ]
    ];


    /**
     * description des header
     *
     * @var ConfigHeader[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigHeader>
     */
    public $configHeader = [
        [
            "header" => "header1",
            "background" => "#ffffff",
            "color" => "#000000"
        ]
    ];


    /**
     * description des footer
     *
     * @var ConfigFooter[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigFooter>
     */
    public $configFooter = [
        [
            "footer" => "footer1",
            "background" => "#f8f8f8",
            "color" => "#666666"
        ]
    ];


    /**
     * description des resaux sociaux
     *
     * @var ConfigResaux[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigResaux>
     */
    public $configResaux = [
        [
            "image" => "/modules/polarisprestatheme/img/tiktok.png",
            "url" => "http:\/\/localhost\/",
            "isVisible" => true
        ],
        [
            "image" => "/modules/polarisprestatheme/img/facebook.png",
            "url" => "http:\/\/localhost\/",
            "isVisible" => true
        ],
        [
            "image" => "/modules/polarisprestatheme/img/instagram.png",
            "url" => "/",
            "isVisible" => true
        ]

    ];


     /**
     * description des categories image
     *
     * @var ConfigCategory[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCategory>
     */
    public $configCategory = [
        [
            "title" => "Homme",
            "subTitle" => "Collection",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/category.png",
            "isVisible" => true
        ],
        [
            "title" => "Femme",
            "subTitle" => "Collection",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/category.png",
            "isVisible" => true
        ],
        [
            "title" => "Enfant",
            "subTitle" => "Collection",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/category.png",
            "isVisible" => true
        ]
    ];


    /**
     * description des ^parametres du block categories
     *
     * @var ConfigCategoryParameter[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCategoryParameter>
     */
    public $configCategoryParameter = [
        [
            "style" => "categorie3",
            "isVisible" => true
        ]
    ];


    
     /**
     * description des sliders
     *
     * @var ConfigSlider[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigSlider>
     */
    public $configSlider = [
        [
            "title" => "Nouvelle collection",
            "subTitle" => "",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/slider.png",
            "button" => "en savoir plus",
            "isVisible" => true,
            "textPosition" => "left"
        ]
    ];



     /**
     * description des sliders
     *
     * @var ConfigSliderParameter[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigSliderParameter>
     */
    public $configSliderParameter = [
        [
            "isVisible" => true,
            "autoPlay" => false,
            "background" => false,
            "width" => true
        ]
    ];


    /**
     * description des nouveau produits
     *
     * @var ConfigNouveauProduit[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigNouveauProduit>
     */
    public $configNouveauProduit = [
        [
            "nbProduit" => 4,
            "isVisible" => true
        ]
    ];

    /**
     * description des promotions produits
     *
     * @var ConfigPromotionProduit[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigPromotionProduit>
     */
    public $configPromotionProduit = [
        [
            "nbProduit" => 4,
            "isVisible" => true
        ]
    ];


     /**
     * description du à propros
     *
     * @var ConfigAbout[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigAbout>
     */
    public $configAbout = [
        [
            "texte" => "<h2 style=\"margin: 0px 0px 10px; padding: 0px; font-weight: 400; font-family: DauphinPlain; font-size: 24px; line-height: 24px; background-color: #ffffff;\">Qu'est-ce que le Lorem Ipsum?</h2><p><span style=\"font-family: 'Open Sans', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: #ffffff;\">Le </span><strong style=\"margin: 0px; padding: 0px; font-family: 'Open Sans', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: #ffffff;\">Lorem Ipsum</strong><span style=\"font-family: 'Open Sans', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: #ffffff;\"> simplement du faux texte employé dans la composition et la mise en page avant impression. Le Lorem Ipsum est le faux texte standard de l'imprimerie depuis les années 1500, quand un imprimeur anonyme assembla ensemble des morceaux de texte pour réaliser un livre spécimen de polices de texte. Il n'a pas fait que survivre cinq siècles, mais s'est aussi adapté à la bureautique informatique, sans que son contenu n'en soit modifié. Il a ét\é popularisé dans les années 1960 gràce à la vente de feuilles Letraset contenant des passages du Lorem Ipsum, et, plus récemment, par son inclusion dans des applications de mise en page de texte, comme Aldus PageMaker.</span></p>",
            "image" => "/modules/polarisprestatheme/img/store.png",
            "isVisible" => true
        ]
    ];


     /**
     * description de la reassurance
     *
     * @var ConfigReassurance[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigReassurance>
     */
    public $configReassurance = [
        [
            "title" => "Livraison offerte",
            "sub_title" => "La livraison est offerte dès 69€ d'achat",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/fast-delivery.png",
            "isVisible" => true
        ],
        [
            "title" => "Paiements sécurisés",
            "sub_title" => "Avec 3D Secure et jusqu'à 4 fois sans frais",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/lock.png",
            "isVisible" => true
        ],
        [
            "title"=> "Une équipe aux petits soins",
            "sub_title"=> "Accompagnement personnalisé",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/customer-support.png",
            "isVisible" => true
        ]

    ];


    
     /**
     * description de la livraison
     *
     * @var ConfigLivraison[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigLivraison>
     */
    public $configLivraison = [
        [
            "isVisible" => true,
            "freeDelivery" => 50,
            "deliveryTime" => 3,
            "shippingTime" => 14,
            "noShippingDays" => [
                "saturday",
                "sunday"
            ]
        ]
    ];

        
     /**
     * description de la page catalogue
     *
     * @var ConfigCatalogue[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCatalogue>
     */
    public $configCatalogue = [
        [
            "color" => false,
            "size" => false,
            "show" => false,
            "colProduct" => 4,
            "pageProduct" => 12,
            "filter" => "filtreGauche"
        ]
    ];


    /**
     * description de la page produit
     *
     * @var ConfigProduct[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigProduct>
     */
    public $configProduct = [
        [
            "imagePosition" => "imagesuppGauche",
            "reduction" => true,
            "quantity" => false,
            "information" => "information2"
        ]
    ];


    /**
     * description du bandeau en haut de page
     *
     * @var ConfigTopBandeau[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTopBandeau>
     */
    public $configTopBandeau = [
        [
            "text" => "Livraison gratuite à partir de 50€",
            "image" => "",
            "isVisible" => true
        ],
        [
            "text" => "Paiement sécurisé avec le 3DSECURE",
            "image" => "",
            "isVisible" => true
        ]
    ];

    /**
     * description des images mise en avant
     *
     * @var ConfigHighlight[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigHighlight>
     */
    public $configHighlight = [
        [
            "title" => "Nouvelle collection",
            "subTitle" => "",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/highlight.png",
            "isVisible" => true
        ],
        [
            "title" => "Vente Privée",
            "subTitle" => "",
            "url" => "/",
            "image" => "/modules/polarisprestatheme/img/highlight.png",
            "isVisible" => true
        ]
    ];


    
    /**
     * parametre du bandeau en haut de page
     *
     * @var ConfigTopBandeauParameter[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTopBandeauParameter>
     */
    public $configTopBandeauParameter = [
        [
             "background" => "#000000",
            "color" => "#ffffff",
            "isVisible" => true
        ]
    ];


    /**
     * Ordre personnalisé des blocs de la home
     *
     * @var string[]
     * @Type Array<string>
     */
    public $configBlockPosition = [];


     /**
     * Configuration du bloc marque
     *
     * @var ConfigBrand[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigBrand>
     */
    public $configBrand = [];


    /**
     * Configuration du bloc menu parent
     *
     * @var ConfigMenuParent[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigMenuParent>
     */
    public $configMenuParent = [];

  /**
     * Configuration du bloc menu child
     *
     * @var ConfigMenuChild[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigMenuChild>
     */
    public $configMenuChild = [];


    /**
     * Configuration de Google Tag Manager
     *
     * @var ConfigTracking[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigTracking>
     */
    public $configTracking = [];


    /**
     * Configuration des Media du Menu
     *
     * @var ConfigMenuMedia[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigMenuMedia>
     */
    public $configMenuMedia = [];


    /**
     * Configuration du pop-up
     *
     * @var ConfigPopUp[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigPopUp>
     */
    public $configPopUp = [];


    
    /**
     * Customisation du CSS
     *
     * @var ConfigCss[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigCss>
     */
    public $configCss = [];


    /**
     * store localisation
     *
     * @var ConfigStore[]
     * @Type Array<PrestaShop\Module\PolarisPrestaTheme\Config\ConfigStore>
     */
    public $configStore = [];


        
    /**
     * Obtient un serializer compatible JSON capable de sérialiser un objet de type ConfigTheme     
     *
     * @return Serializer
     */
    private static function getSerializer() : Serializer
    {
        return new Serializer( [
            new ObjectNormalizer(null, null, null, 
                new PropertyInfoExtractor([], [
                    new PhpDocExtractor(),
                    new ReflectionExtractor(),
                ])), 
            new ArrayDenormalizer()
        ], [new JsonEncoder()]);
    }

    public static function load(string $configFile = self::themeConfigFile) : ConfigTheme {
        if (!file_exists($configFile)){
            $fichierJson = new ConfigTheme();
            $fichierJson->save();
        }
        
        //throw new \Exception("fichier de configuration de thème introuvable");
        $content = file_get_contents($configFile);
        if(!$content) {
            $fichierJson = new ConfigTheme();
            $fichierJson->save($configFile);
            $content = file_get_contents($configFile);
        }
        
        $config = self::getSerializer()->deserialize($content, self::class, 'json');
        

        // Vérification des valeurs par défaut
        if (!$config->configBlockPosition || !is_array($config->configBlockPosition)) {            
            $config->configBlockPosition = [
                                                "new_products",
                                                "category",
                                                "about",
                                                "sale_products",
                                                "highlight",
                                                "brand"
            ];
        }
        
        // Les éléments uniques
        if (!$config->configGeneral) 
            $config->configGeneral = [new ConfigGeneral()];
        if (!$config->configHeader) 
            $config->configHeader = [new ConfigHeader()];   
        if (!$config->configFooter)
            $config->configFooter = [new ConfigFooter()];
        if (!$config->configCatalogue)
            $config->configCatalogue = [new ConfigCatalogue()];        
        if (!$config->configSliderParameter)
            $config->configSliderParameter = [new ConfigSliderParameter()];

        if (!$config->configNouveauProduit)
            $config->configNouveauProduit = [new ConfigNouveauProduit()];

        if (!$config->configPromotionProduit)
            $config->configPromotionProduit = [new ConfigPromotionProduit()];

        if (!$config->configCategoryParameter)
            $config->configCategoryParameter = [new ConfigCategoryParameter()];

        if (!$config->configAbout)
            $config->configAbout = [new ConfigAbout()];

        if (!$config->configLivraison)
            $config->configLivraison = [new configLivraison()];

        if (!$config->configProduct)
            $config->configProduct = [new ConfigProduct()];

        if (!$config->configCatalogue)
            $config->configCatalogue = [new ConfigCatalogue()];

        if (!$config->configTopBandeauParameter)
            $config->configTopBandeauParameter = [new ConfigTopBandeauParameter()];

        if (!$config->configBrand)
            $config->configBrand = [new ConfigBrand()];

        if (!$config->configTracking)
            $config->configTracking = [new ConfigTracking()];            
        
        if (!isset($config->configResaux)) $config->configResaux = [];
        if (!isset($config->configCategory))$config->configCategory = [];
        if (!isset($config->configSlider)) $config->configSlider = [];
        if (!isset($config->configReassurance)) $config->configReassurance = [];             
        if (!isset($config->configTopBandeau)) $config->configTopBandeau = [];
        if (!isset($config->configHighlight)) $config->configHighlight = [];
        if (!isset($config->configMenuParent)) $config->configMenuParent = [];
        if (!isset($config->configMenuChild)) $config->configMenuChild = [];
        if (!isset($config->configTracking)) $config->configTracking = [];
        if (!isset($config->configMenuMedia)) $config->configMenuMedia = [];
        if (!isset($config->configReassurance)) $config->configReassurance = [];
        
        return $config;
    }

    public function save(string $outputFile = self::themeConfigFile) {       
        $jsonContent = self::getSerializer()->serialize($this, 'json', ['json_encode_options' => \JSON_PRETTY_PRINT]);
        file_put_contents($outputFile, $jsonContent);
    }



}