{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}

  <div class="product-add-to-cart js-product-add-to-cart">
    {if !$configuration.is_catalog}
      {* <span class="control-label">{l s='Quantity' d='Shop.Theme.Catalog'}</span> *}
      {block name='product_quantity'}
        <div class="product-quantity clearfix">
          {if !empty($productParameter) && $productParameter[0]->quantity}
            <div class="qty">
              <input
                type="number"
                name="qty"
                id="quantity_wanted"
                inputmode="numeric"
                pattern="[0-9]*"
                {if $product.quantity_wanted}
                  value="{$product.quantity_wanted}"
                  min="{$product.minimal_quantity}"
                {else}
                  value="1"
                  min="1"
                {/if}
                class="input-group"
                aria-label="{l s='Quantity' d='Shop.Theme.Actions'}"
              >
            </div>
          {/if}

          <div class="add">
            <button
              class="btn btn-primary add-to-cart"
              data-button-action="add-to-cart"
              type="submit"
              {if !$product.add_to_cart_url}
                disabled
              {/if}
            >
              <svg xmlns="http://www.w3.org/2000/svg" class="shopping-cart" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M280-80q-33 0-56.5-23.5T200-160q0-33 23.5-56.5T280-240q33 0 56.5 23.5T360-160q0 33-23.5 56.5T280-80Zm400 0q-33 0-56.5-23.5T600-160q0-33 23.5-56.5T680-240q33 0 56.5 23.5T760-160q0 33-23.5 56.5T680-80ZM246-720l96 200h280l110-200H246Zm-38-80h590q23 0 35 20.5t1 41.5L692-482q-11 20-29.5 31T622-440H324l-44 80h480v80H280q-45 0-68-39.5t-2-78.5l54-98-144-304H40v-80h130l38 80Zm134 280h280-280Z"/></svg>
              {l s='Add to cart' d='Shop.Theme.Actions'}
            </button>
            {hook h='displayWishlistButton' product=$product}
          </div>

          {hook h='displayProductActions' product=$product}
        </div>
      {/block}

      {block name='product_minimal_quantity'}
        <p class="product-minimal-quantity js-product-minimal-quantity">
          {if $product.minimal_quantity > 1}
            {l
            s='The minimum purchase order quantity for the product is %quantity%.'
            d='Shop.Theme.Checkout'
            sprintf=['%quantity%' => $product.minimal_quantity]
            }
          {/if}
        </p>
      {/block}
    {/if}
  </div>
  {block name='product_availability'}
    <div id="product-availability" class="col-sm-12 js-product-availability">
      {if $product.show_availability && $product.availability_message}
        {if $product.availability == 'available'}
          <svg xmlns="http://www.w3.org/2000/svg" class="rtl-no-flip product-available" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M382-240 154-468l57-57 171 171 367-367 57 57-424 424Z"/></svg>
        {elseif $product.availability == 'last_remaining_items'}
          <svg xmlns="http://www.w3.org/2000/svg" class="product-last-items" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="m40-120 440-760 440 760H40Zm138-80h604L480-720 178-200Zm302-40q17 0 28.5-11.5T520-280q0-17-11.5-28.5T480-320q-17 0-28.5 11.5T440-280q0 17 11.5 28.5T480-240Zm-40-120h80v-200h-80v200Zm40-100Z"/></svg>
        {else}
          <svg xmlns="http://www.w3.org/2000/svg" class="product-unavailable" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M480-80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q54 0 104-17.5t92-50.5L228-676q-33 42-50.5 92T160-480q0 134 93 227t227 93Zm252-124q33-42 50.5-92T800-480q0-134-93-227t-227-93q-54 0-104 17.5T284-732l448 448Z"/></svg>
        {/if}
        {$product.availability_message}
      {/if}
    </div>
  {/block}
