{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
 <div id="blockcart-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title h6 text-sm-center" id="myModalLabel">
          {l s='Product successfully added to your shopping cart' d='Shop.Theme.Checkout'}
        </h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="{l s='Close' d='Shop.Theme.Global'}">
          <span aria-hidden="true"><svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/></svg></span>
        </button>
      </div>
      
      <div class="modal-body">
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 divide-right">
            <div class="row">
              {if $cart.products}
                <ul class="cart-items">              
                  {foreach from=$cart.products item=product}
                    <li class="cart-product-line">{include 'module:ps_shoppingcart/ps_shoppingcart-product-line.tpl' product=$product}</li>
                  {/foreach}
                </ul>       
              {else}
                <div class="no-items">
                  {l s='There are no more items in your cart' d='Shop.Theme.Checkout'}
                </div>
              {/if}              
            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="delivery-info-btn">
          {hook h="displayFreeDelivery"}
        </div>
        <div class="modal-btn">
          <div class="cart-content-btn">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">
              {l s='Continue shopping' d='Shop.Theme.Actions'}
            </button>
            <a href="{$cart_url}" class="btn btn-primary">
              {l s='Proceed to checkout' d='Shop.Theme.Actions'} | {$cart.totals.total_including_tax.value}
            </a>
          </div>
          {hook h='displayCartModalFooter' product=$product}
        </div>
      </div>

    </div>
  </div>
</div>