<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Forms;

use PrestaShopBundle\Form\Admin\Type\ButtonCollectionType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;

class MappingType extends ConnectorType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {   
        // Obtenir les données du form passé dans le createForm
        $data = $options['data'];
        
        $hint = null;
        if ($data['id'] == '*')
            $hint = 'Utilisez ce champ pour indiquer quelle option utiliser quand aucun mappage n\'est défini.';
           
        $builder->add('choice', ChoiceType::class, [
            'choices' => $data['choices'],
            'label' => $data['label'],
            'help' => $hint,
            'required' => false,
            'data' => $data['choice'],
            'placeholder' => $data['placeholder'],
        ]);        
        
        $builder->add('actions', ButtonCollectionType::class, [
            'required' => false,
            'buttons' => [
                'cancel' => [
                    'type' => ButtonType::class,
                    'options' => [                        
                        'label' => 'Annuler',
                        'attr' => [
                            'class' => 'btn-form-valid btn-outline-secondary',
                            'onclick' => 'window.location.href="'.$data['cancel'].'"'
                        ]
                    ]
                ],
                'submit' => [
                    'type' => SubmitType::class,
                    'options' => [
                        'label' => 'Enregistrer',
                        'attr' => ['class' => 'btn-form-valid btn-primary']
                    ]
                ],            
            ],
            'attr' => [
                'class' => 'prestaconnector-row-actions',
            ],        
        ]);
    }

}