<?php
/**
 * Promotion
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * Promotion Class Doc Comment
 *
 * @category Class
 * @description Promotion   (fullname : ApiPolaris.WebConnect.Models.Promotion)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Promotion implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Promotion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'nom' => 'string',
        'code_magasin' => 'int',
        'date_debut' => '\DateTime',
        'date_fin' => '\DateTime',
        'solde' => 'bool',
        'sur_internet' => 'bool',
        'en_magasin' => 'bool',
        'code_activation' => 'string',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code' => null,
        'nom' => null,
        'code_magasin' => 'int32',
        'date_debut' => 'date-time',
        'date_fin' => 'date-time',
        'solde' => null,
        'sur_internet' => null,
        'en_magasin' => null,
        'code_activation' => null,
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code' => false,
        'nom' => false,
        'code_magasin' => false,
        'date_debut' => false,
        'date_fin' => false,
        'solde' => false,
        'sur_internet' => false,
        'en_magasin' => false,
        'code_activation' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'Code',
        'nom' => 'Nom',
        'code_magasin' => 'CodeMagasin',
        'date_debut' => 'DateDebut',
        'date_fin' => 'DateFin',
        'solde' => 'Solde',
        'sur_internet' => 'SurInternet',
        'en_magasin' => 'EnMagasin',
        'code_activation' => 'CodeActivation',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'nom' => 'setNom',
        'code_magasin' => 'setCodeMagasin',
        'date_debut' => 'setDateDebut',
        'date_fin' => 'setDateFin',
        'solde' => 'setSolde',
        'sur_internet' => 'setSurInternet',
        'en_magasin' => 'setEnMagasin',
        'code_activation' => 'setCodeActivation',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'nom' => 'getNom',
        'code_magasin' => 'getCodeMagasin',
        'date_debut' => 'getDateDebut',
        'date_fin' => 'getDateFin',
        'solde' => 'getSolde',
        'sur_internet' => 'getSurInternet',
        'en_magasin' => 'getEnMagasin',
        'code_activation' => 'getCodeActivation',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('nom', $data ?? [], null);
        $this->setIfExists('code_magasin', $data ?? [], 0);
        $this->setIfExists('date_debut', $data ?? [], null);
        $this->setIfExists('date_fin', $data ?? [], null);
        $this->setIfExists('solde', $data ?? [], false);
        $this->setIfExists('sur_internet', $data ?? [], false);
        $this->setIfExists('en_magasin', $data ?? [], false);
        $this->setIfExists('code_activation', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code unique d'identification de la promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets nom
     *
     * @return string|null
     */
    public function getNom()
    {
        return $this->container['nom'];
    }

    /**
     * Sets nom
     *
     * @param string|null $nom Nom de l'opération    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNom($nom)
    {
        if (is_null($nom)) {
            throw new \InvalidArgumentException('non-nullable nom cannot be null');
        }
        $this->container['nom'] = $nom;

        return $this;
    }

    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Code du magasin concerné par l'opération    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            throw new \InvalidArgumentException('non-nullable code_magasin cannot be null');
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets date_debut
     *
     * @return \DateTime|null
     */
    public function getDateDebut()
    {
        return $this->container['date_debut'];
    }

    /**
     * Sets date_debut
     *
     * @param \DateTime|null $date_debut Date et heure de début de la promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateDebut($date_debut)
    {
        if (is_null($date_debut)) {
            throw new \InvalidArgumentException('non-nullable date_debut cannot be null');
        }
        $this->container['date_debut'] = $date_debut;

        return $this;
    }

    /**
     * Gets date_fin
     *
     * @return \DateTime|null
     */
    public function getDateFin()
    {
        return $this->container['date_fin'];
    }

    /**
     * Sets date_fin
     *
     * @param \DateTime|null $date_fin Date et heure de fin de la promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateFin($date_fin)
    {
        if (is_null($date_fin)) {
            throw new \InvalidArgumentException('non-nullable date_fin cannot be null');
        }
        $this->container['date_fin'] = $date_fin;

        return $this;
    }

    /**
     * Gets solde
     *
     * @return bool|null
     */
    public function getSolde()
    {
        return $this->container['solde'];
    }

    /**
     * Sets solde
     *
     * @param bool|null $solde Vrai s'il s'agit d'une solde, faux s'il s'agit d'une promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setSolde($solde)
    {
        if (is_null($solde)) {
            throw new \InvalidArgumentException('non-nullable solde cannot be null');
        }
        $this->container['solde'] = $solde;

        return $this;
    }

    /**
     * Gets sur_internet
     *
     * @return bool|null
     */
    public function getSurInternet()
    {
        return $this->container['sur_internet'];
    }

    /**
     * Sets sur_internet
     *
     * @param bool|null $sur_internet Vrai s'il s'agit d'une opération concernant les sites Internet    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setSurInternet($sur_internet)
    {
        if (is_null($sur_internet)) {
            throw new \InvalidArgumentException('non-nullable sur_internet cannot be null');
        }
        $this->container['sur_internet'] = $sur_internet;

        return $this;
    }

    /**
     * Gets en_magasin
     *
     * @return bool|null
     */
    public function getEnMagasin()
    {
        return $this->container['en_magasin'];
    }

    /**
     * Sets en_magasin
     *
     * @param bool|null $en_magasin Vrai s'il s'agit d'une opération concernant les boutiques physiques    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEnMagasin($en_magasin)
    {
        if (is_null($en_magasin)) {
            throw new \InvalidArgumentException('non-nullable en_magasin cannot be null');
        }
        $this->container['en_magasin'] = $en_magasin;

        return $this;
    }

    /**
     * Gets code_activation
     *
     * @return string|null
     */
    public function getCodeActivation()
    {
        return $this->container['code_activation'];
    }

    /**
     * Sets code_activation
     *
     * @param string|null $code_activation Si la promotion est assujettie à la saisie d'un code    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeActivation($code_activation)
    {
        if (is_null($code_activation)) {
            throw new \InvalidArgumentException('non-nullable code_activation cannot be null');
        }
        $this->container['code_activation'] = $code_activation;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification de la promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


