<?php
/**
 * MetierClientWebConnextTicket
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierClientWebConnextTicket Class Doc Comment
 *
 * @category Class
 * @description ticket d&#39;un client   (fullname : piu_Clients.MetierClient.WebConnextTicket)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierClientWebConnextTicket implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierClient_WebConnextTicket';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id_ticket' => 'int',
        'date' => '\DateTime',
        'code_magasin' => 'int',
        'detail_ventes' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnextDetailVente[]',
        'ref_ext' => 'string',
        'annuler' => 'string',
        'id_client' => 'int',
        'mail' => 'string',
        'refs_ext' => 'string[]',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id_ticket' => 'int64',
        'date' => 'date-time',
        'code_magasin' => 'int32',
        'detail_ventes' => null,
        'ref_ext' => null,
        'annuler' => null,
        'id_client' => 'int64',
        'mail' => null,
        'refs_ext' => null,
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id_ticket' => false,
        'date' => true,
        'code_magasin' => false,
        'detail_ventes' => false,
        'ref_ext' => false,
        'annuler' => false,
        'id_client' => true,
        'mail' => false,
        'refs_ext' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id_ticket' => 'idTicket',
        'date' => 'date',
        'code_magasin' => 'CodeMagasin',
        'detail_ventes' => 'detailVentes',
        'ref_ext' => 'RefExt',
        'annuler' => 'Annuler',
        'id_client' => 'IdClient',
        'mail' => 'Mail',
        'refs_ext' => 'RefsExt',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id_ticket' => 'setIdTicket',
        'date' => 'setDate',
        'code_magasin' => 'setCodeMagasin',
        'detail_ventes' => 'setDetailVentes',
        'ref_ext' => 'setRefExt',
        'annuler' => 'setAnnuler',
        'id_client' => 'setIdClient',
        'mail' => 'setMail',
        'refs_ext' => 'setRefsExt',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id_ticket' => 'getIdTicket',
        'date' => 'getDate',
        'code_magasin' => 'getCodeMagasin',
        'detail_ventes' => 'getDetailVentes',
        'ref_ext' => 'getRefExt',
        'annuler' => 'getAnnuler',
        'id_client' => 'getIdClient',
        'mail' => 'getMail',
        'refs_ext' => 'getRefsExt',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id_ticket', $data ?? [], null);
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('code_magasin', $data ?? [], null);
        $this->setIfExists('detail_ventes', $data ?? [], null);
        $this->setIfExists('ref_ext', $data ?? [], null);
        $this->setIfExists('annuler', $data ?? [], null);
        $this->setIfExists('id_client', $data ?? [], null);
        $this->setIfExists('mail', $data ?? [], null);
        $this->setIfExists('refs_ext', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id_ticket
     *
     * @return int|null
     */
    public function getIdTicket()
    {
        return $this->container['id_ticket'];
    }

    /**
     * Sets id_ticket
     *
     * @param int|null $id_ticket Numéro du ticket (en lecture seule uniquement)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setIdTicket($id_ticket)
    {
        if (is_null($id_ticket)) {
            throw new \InvalidArgumentException('non-nullable id_ticket cannot be null');
        }
        $this->container['id_ticket'] = $id_ticket;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date Date de vente    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            array_push($this->openAPINullablesSetToNull, 'date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Code du magasin    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            throw new \InvalidArgumentException('non-nullable code_magasin cannot be null');
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets detail_ventes
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnextDetailVente[]|null
     */
    public function getDetailVentes()
    {
        return $this->container['detail_ventes'];
    }

    /**
     * Sets detail_ventes
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnextDetailVente[]|null $detail_ventes Détails de la vente
     *
     * @return self
     */
    public function setDetailVentes($detail_ventes)
    {
        if (is_null($detail_ventes)) {
            throw new \InvalidArgumentException('non-nullable detail_ventes cannot be null');
        }
        $this->container['detail_ventes'] = $detail_ventes;

        return $this;
    }

    /**
     * Gets ref_ext
     *
     * @return string|null
     */
    public function getRefExt()
    {
        return $this->container['ref_ext'];
    }

    /**
     * Sets ref_ext
     *
     * @param string|null $ref_ext Référence extérieure de la vente. Cette référence doit-être unique.    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefExt($ref_ext)
    {
        if (is_null($ref_ext)) {
            throw new \InvalidArgumentException('non-nullable ref_ext cannot be null');
        }
        $this->container['ref_ext'] = $ref_ext;

        return $this;
    }

    /**
     * Gets annuler
     *
     * @return string|null
     */
    public function getAnnuler()
    {
        return $this->container['annuler'];
    }

    /**
     * Sets annuler
     *
     * @param string|null $annuler La vente est annulée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setAnnuler($annuler)
    {
        if (is_null($annuler)) {
            throw new \InvalidArgumentException('non-nullable annuler cannot be null');
        }
        $this->container['annuler'] = $annuler;

        return $this;
    }

    /**
     * Gets id_client
     *
     * @return int|null
     */
    public function getIdClient()
    {
        return $this->container['id_client'];
    }

    /**
     * Sets id_client
     *
     * @param int|null $id_client Numéro interne du client (code client, en lecture seule uniquement)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setIdClient($id_client)
    {
        if (is_null($id_client)) {
            array_push($this->openAPINullablesSetToNull, 'id_client');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('id_client', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['id_client'] = $id_client;

        return $this;
    }

    /**
     * Gets mail
     *
     * @return string|null
     */
    public function getMail()
    {
        return $this->container['mail'];
    }

    /**
     * Sets mail
     *
     * @param string|null $mail Adresse mail du client    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMail($mail)
    {
        if (is_null($mail)) {
            throw new \InvalidArgumentException('non-nullable mail cannot be null');
        }
        $this->container['mail'] = $mail;

        return $this;
    }

    /**
     * Gets refs_ext
     *
     * @return string[]|null
     */
    public function getRefsExt()
    {
        return $this->container['refs_ext'];
    }

    /**
     * Sets refs_ext
     *
     * @param string[]|null $refs_ext Vos références    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefsExt($refs_ext)
    {
        if (is_null($refs_ext)) {
            throw new \InvalidArgumentException('non-nullable refs_ext cannot be null');
        }
        $this->container['refs_ext'] = $refs_ext;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification du détail de promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


