<?php
/**
 * CdeDetailTaille
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * CdeDetailTaille Class Doc Comment
 *
 * @category Class
 * @description Taille pour un produit, avec information de commande   (fullname : ApiPolaris.WebConnect.Models.CdeDetailTaille)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CdeDetailTaille implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CdeDetailTaille';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'taille' => 'string',
        'refs' => 'string[]',
        'eans' => 'string[]',
        'gtin_p' => 'string[]',
        'gtin_f' => 'string[]',
        'magasins_date' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\CdeDateMagasin[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'taille' => null,
        'refs' => null,
        'eans' => null,
        'gtin_p' => null,
        'gtin_f' => null,
        'magasins_date' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'taille' => false,
        'refs' => false,
        'eans' => false,
        'gtin_p' => false,
        'gtin_f' => false,
        'magasins_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'taille' => 'Taille',
        'refs' => 'Refs',
        'eans' => 'Eans',
        'gtin_p' => 'GTIN_P',
        'gtin_f' => 'GTIN_F',
        'magasins_date' => 'MagasinsDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'taille' => 'setTaille',
        'refs' => 'setRefs',
        'eans' => 'setEans',
        'gtin_p' => 'setGtinP',
        'gtin_f' => 'setGtinF',
        'magasins_date' => 'setMagasinsDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'taille' => 'getTaille',
        'refs' => 'getRefs',
        'eans' => 'getEans',
        'gtin_p' => 'getGtinP',
        'gtin_f' => 'getGtinF',
        'magasins_date' => 'getMagasinsDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('taille', $data ?? [], null);
        $this->setIfExists('refs', $data ?? [], null);
        $this->setIfExists('eans', $data ?? [], null);
        $this->setIfExists('gtin_p', $data ?? [], null);
        $this->setIfExists('gtin_f', $data ?? [], null);
        $this->setIfExists('magasins_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets taille
     *
     * @return string|null
     */
    public function getTaille()
    {
        return $this->container['taille'];
    }

    /**
     * Sets taille
     *
     * @param string|null $taille Taille
     *
     * @return self
     */
    public function setTaille($taille)
    {
        if (is_null($taille)) {
            throw new \InvalidArgumentException('non-nullable taille cannot be null');
        }
        $this->container['taille'] = $taille;

        return $this;
    }

    /**
     * Gets refs
     *
     * @return string[]|null
     */
    public function getRefs()
    {
        return $this->container['refs'];
    }

    /**
     * Sets refs
     *
     * @param string[]|null $refs Codes barres Polaris
     *
     * @return self
     */
    public function setRefs($refs)
    {
        if (is_null($refs)) {
            throw new \InvalidArgumentException('non-nullable refs cannot be null');
        }
        $this->container['refs'] = $refs;

        return $this;
    }

    /**
     * Gets eans
     *
     * @return string[]|null
     */
    public function getEans()
    {
        return $this->container['eans'];
    }

    /**
     * Sets eans
     *
     * @param string[]|null $eans Codes barres Fournisseur (si existant)
     *
     * @return self
     */
    public function setEans($eans)
    {
        if (is_null($eans)) {
            throw new \InvalidArgumentException('non-nullable eans cannot be null');
        }
        $this->container['eans'] = $eans;

        return $this;
    }

    /**
     * Gets gtin_p
     *
     * @return string[]|null
     */
    public function getGtinP()
    {
        return $this->container['gtin_p'];
    }

    /**
     * Sets gtin_p
     *
     * @param string[]|null $gtin_p GTIN Polaris (si existant)
     *
     * @return self
     */
    public function setGtinP($gtin_p)
    {
        if (is_null($gtin_p)) {
            throw new \InvalidArgumentException('non-nullable gtin_p cannot be null');
        }
        $this->container['gtin_p'] = $gtin_p;

        return $this;
    }

    /**
     * Gets gtin_f
     *
     * @return string[]|null
     */
    public function getGtinF()
    {
        return $this->container['gtin_f'];
    }

    /**
     * Sets gtin_f
     *
     * @param string[]|null $gtin_f GTIN Fournisseur (si existant)
     *
     * @return self
     */
    public function setGtinF($gtin_f)
    {
        if (is_null($gtin_f)) {
            throw new \InvalidArgumentException('non-nullable gtin_f cannot be null');
        }
        $this->container['gtin_f'] = $gtin_f;

        return $this;
    }

    /**
     * Gets magasins_date
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\CdeDateMagasin[]|null
     */
    public function getMagasinsDate()
    {
        return $this->container['magasins_date'];
    }

    /**
     * Sets magasins_date
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\CdeDateMagasin[]|null $magasins_date Details par magasin et par magasin
     *
     * @return self
     */
    public function setMagasinsDate($magasins_date)
    {
        if (is_null($magasins_date)) {
            throw new \InvalidArgumentException('non-nullable magasins_date cannot be null');
        }
        $this->container['magasins_date'] = $magasins_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


