<?php
namespace PrestaShop\Module\PolarisPrestaConnector;

use PolarisPrestaConnector;

class Upgrade_0_3 {    
    /**
     * Déclenche la mise à jour de la base de données du module
     */
    public function upgrade(PolarisPrestaConnector $module, $db)
    {
          // On créer la table de configuration du module
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'configuration` (
                    `key` VARCHAR(255) NOT NULL,
                    `value` JSON,
                    PRIMARY KEY (`key`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de configuration du module');

          // On créer une table de mappage pour les photos
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'image` (
                    `photo` VARCHAR(255) NOT NULL,
                    `id_product` INT(10) UNSIGNED NOT NULL,
                    `id_image` INT(10) UNSIGNED NOT NULL,
                    PRIMARY KEY (`photo`, `id_product`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de mappage des photos');

          // On créer la clé étrangère entre la table image et la table image de prestashop sur id_image si elle n'existe pas
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'image` ADD CONSTRAINT FOREIGN KEY (`id_product`) REFERENCES `' . _DB_PREFIX_ . 'product` (`id_product`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table image et la table product de prestashop');
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'image` ADD CONSTRAINT FOREIGN KEY (`id_image`) REFERENCES `' . _DB_PREFIX_ . 'image` (`id_image`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table image et la table image de prestashop');

          // On créer une table pour les stocks
          // Qui associe à un couple "id_product_attribute, store_code", une quantité en stock et une quantité en commande
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'stocks` (
                    `id_product` INT(10) UNSIGNED NOT NULL,
                    `id_product_attribute` INT(10) UNSIGNED NOT NULL,
                    `store_code` VARCHAR(20) NOT NULL,
                    `qty` INT(10) UNSIGNED NOT NULL,                
                    PRIMARY KEY (`id_product_attribute`, `store_code`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de mappage des stocks');

          // On crée la clé étrangère qui lie le id_product à la table product
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'stocks` ADD CONSTRAINT FOREIGN KEY (`id_product`) REFERENCES `' . _DB_PREFIX_ . 'product` (`id_product`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table stock et la table product de prestashop');

          // On crée la clé étrangère qui lie le id_product_attribute à la table product_attribute
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'stocks` ADD CONSTRAINT FOREIGN KEY (`id_product_attribute`) REFERENCES `' . _DB_PREFIX_ . 'product_attribute` (`id_product_attribute`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table stock et la table product_attribute de prestashop');

          // Création d'une table pour stocker les promotions : code, libelle, date de début, date de fin et lien avec catégorie prestashop pour y ranger les produits concernés (optionnel)
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'promotion` (
                    `code` VARCHAR(20) NOT NULL,
                    `label` VARCHAR(255) NOT NULL,
                    `date_start` DATETIME NOT NULL,
                    `date_end` DATETIME NOT NULL,
                    `id_category` INT(10) UNSIGNED,
                    PRIMARY KEY (`code`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de mappage des promotions');
          // On crée la clé étrangère qui lie le id_category à la table category
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion` ADD CONSTRAINT FOREIGN KEY (`id_category`) REFERENCES `' . _DB_PREFIX_ . 'category` (`id_category`) ON DELETE SET NULL;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion et la table category de prestashop');

          // On crée maintenant la table de détails de promotion qui associe un produit et un product_attribute à une promotion, en précisant le pourcentage de réduction et
          // un flag qui indique si la promotion est valide ou à effacer
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'promotion_detail` (
                    `code` VARCHAR(20) NOT NULL,
                    `id_product` INT(10) UNSIGNED NOT NULL,
                    `id_product_attribute` INT(10) UNSIGNED NOT NULL,
                    `id_specific_price` INT(10) UNSIGNED,
                    `id_category` INT(10) UNSIGNED,
                    `reduction` DECIMAL(10,2) NOT NULL,
                    PRIMARY KEY (`code`, `id_product`, `id_product_attribute`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table de mappage des détails de promotion');

          // On crée la clé étrangère qui lie le code à la table promotion
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion_detail` ADD CONSTRAINT FOREIGN KEY (`code`) REFERENCES `' . $module->TblPrefix . 'promotion` (`code`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion_detail et la table promotion');
          // On crée la clé étrangère qui lie le id_product à la table product
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion_detail` ADD CONSTRAINT FOREIGN KEY (`id_product`) REFERENCES `' . _DB_PREFIX_ . 'product` (`id_product`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion_detail et la table product');
          // On crée la clé étrangère qui lie le id_product_attribute à la table product_attribute
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion_detail` ADD CONSTRAINT FOREIGN KEY (`id_product_attribute`) REFERENCES `' . _DB_PREFIX_ . 'product_attribute` (`id_product_attribute`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion_detail et la table product_attribute de prestashop');
          // On crée la clé étrangère qui lie le id_specific_price à la table specific_price
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion_detail` ADD CONSTRAINT FOREIGN KEY (`id_specific_price`) REFERENCES `' . _DB_PREFIX_ . 'specific_price` (`id_specific_price`) ON DELETE SET NULL;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion_detail et la table specific_price de prestashop');
          // On crée la clé étrangère qui lie le id_category à la table category
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'promotion_detail` ADD CONSTRAINT FOREIGN KEY (`id_category`) REFERENCES `' . _DB_PREFIX_ . 'category` (`id_category`) ON DELETE SET NULL;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table promotion_detail et la table category de prestashop');

          // Maintenant on crée une table pour stocker les informations supplémentaires sur les produits
          // qui viennent du backoffice
          if (!$db->execute('
               CREATE TABLE IF NOT EXISTS `' . $module->TblPrefix . 'product` (
                    `id_product` INT(10) UNSIGNED NOT NULL,
                    `backoffice_categorization` JSON NOT NULL DEFAULT \'null\',                    
                    `applied_categorization` JSON NOT NULL DEFAULT \'null\',
                    `given_categorization` JSON NOT NULL DEFAULT \'null\',
                    PRIMARY KEY (`id_product`)
               ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'))
               throw new \Exception('Erreur lors de la création de la table d\'informations étendues des produits');
          // On lie le id_product à la table product
          if (!$db->execute('ALTER TABLE `' . $module->TblPrefix . 'product` ADD CONSTRAINT FOREIGN KEY (`id_product`) REFERENCES `' . _DB_PREFIX_ . 'product` (`id_product`) ON DELETE CASCADE;'))
               throw new \Exception('Erreur lors de la création de la clé étrangère entre la table product et la table product de prestashop');
    }
}