<?php
/**
 * DetailPromotion
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * DetailPromotion Class Doc Comment
 *
 * @category Class
 * @description Détail de plan de promotion   (fullname : ApiPolaris.WebConnect.Models.DetailPromotion)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DetailPromotion implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DetailPromotion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'code_promotion' => 'string',
        'debut' => '\DateTime',
        'fin' => '\DateTime',
        'ref_produit' => 'int',
        'ean' => 'string',
        'gtin_p' => 'string',
        'gtin_f' => 'string',
        'p' => 'float',
        'pvs' => 'float',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code' => null,
        'code_promotion' => null,
        'debut' => 'date-time',
        'fin' => 'date-time',
        'ref_produit' => 'int64',
        'ean' => null,
        'gtin_p' => null,
        'gtin_f' => null,
        'p' => 'decimal',
        'pvs' => 'decimal',
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code' => false,
        'code_promotion' => false,
        'debut' => false,
        'fin' => false,
        'ref_produit' => false,
        'ean' => false,
        'gtin_p' => false,
        'gtin_f' => false,
        'p' => false,
        'pvs' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'Code',
        'code_promotion' => 'CodePromotion',
        'debut' => 'Debut',
        'fin' => 'Fin',
        'ref_produit' => 'RefProduit',
        'ean' => 'Ean',
        'gtin_p' => 'GTIN_P',
        'gtin_f' => 'GTIN_F',
        'p' => 'P',
        'pvs' => 'PVS',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'code_promotion' => 'setCodePromotion',
        'debut' => 'setDebut',
        'fin' => 'setFin',
        'ref_produit' => 'setRefProduit',
        'ean' => 'setEan',
        'gtin_p' => 'setGtinP',
        'gtin_f' => 'setGtinF',
        'p' => 'setP',
        'pvs' => 'setPvs',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'code_promotion' => 'getCodePromotion',
        'debut' => 'getDebut',
        'fin' => 'getFin',
        'ref_produit' => 'getRefProduit',
        'ean' => 'getEan',
        'gtin_p' => 'getGtinP',
        'gtin_f' => 'getGtinF',
        'p' => 'getP',
        'pvs' => 'getPvs',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('code_promotion', $data ?? [], null);
        $this->setIfExists('debut', $data ?? [], null);
        $this->setIfExists('fin', $data ?? [], null);
        $this->setIfExists('ref_produit', $data ?? [], 0);
        $this->setIfExists('ean', $data ?? [], null);
        $this->setIfExists('gtin_p', $data ?? [], null);
        $this->setIfExists('gtin_f', $data ?? [], null);
        $this->setIfExists('p', $data ?? [], null);
        $this->setIfExists('pvs', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Numéro d'identification du détail de promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets code_promotion
     *
     * @return string|null
     */
    public function getCodePromotion()
    {
        return $this->container['code_promotion'];
    }

    /**
     * Sets code_promotion
     *
     * @param string|null $code_promotion Promotion liée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodePromotion($code_promotion)
    {
        if (is_null($code_promotion)) {
            throw new \InvalidArgumentException('non-nullable code_promotion cannot be null');
        }
        $this->container['code_promotion'] = $code_promotion;

        return $this;
    }

    /**
     * Gets debut
     *
     * @return \DateTime|null
     */
    public function getDebut()
    {
        return $this->container['debut'];
    }

    /**
     * Sets debut
     *
     * @param \DateTime|null $debut Date de début de l'offre    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDebut($debut)
    {
        if (is_null($debut)) {
            throw new \InvalidArgumentException('non-nullable debut cannot be null');
        }
        $this->container['debut'] = $debut;

        return $this;
    }

    /**
     * Gets fin
     *
     * @return \DateTime|null
     */
    public function getFin()
    {
        return $this->container['fin'];
    }

    /**
     * Sets fin
     *
     * @param \DateTime|null $fin Date de fin de l'offre    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setFin($fin)
    {
        if (is_null($fin)) {
            throw new \InvalidArgumentException('non-nullable fin cannot be null');
        }
        $this->container['fin'] = $fin;

        return $this;
    }

    /**
     * Gets ref_produit
     *
     * @return int|null
     */
    public function getRefProduit()
    {
        return $this->container['ref_produit'];
    }

    /**
     * Sets ref_produit
     *
     * @param int|null $ref_produit Code barres Polaris du produit concerné (eq à RefEanPolaris)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefProduit($ref_produit)
    {
        if (is_null($ref_produit)) {
            throw new \InvalidArgumentException('non-nullable ref_produit cannot be null');
        }
        $this->container['ref_produit'] = $ref_produit;

        return $this;
    }

    /**
     * Gets ean
     *
     * @return string|null
     */
    public function getEan()
    {
        return $this->container['ean'];
    }

    /**
     * Sets ean
     *
     * @param string|null $ean Code EAN du produit concerné, si existant    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEan($ean)
    {
        if (is_null($ean)) {
            throw new \InvalidArgumentException('non-nullable ean cannot be null');
        }
        $this->container['ean'] = $ean;

        return $this;
    }

    /**
     * Gets gtin_p
     *
     * @return string|null
     */
    public function getGtinP()
    {
        return $this->container['gtin_p'];
    }

    /**
     * Sets gtin_p
     *
     * @param string|null $gtin_p GTIN Polaris du produit concerné, si existant     *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setGtinP($gtin_p)
    {
        if (is_null($gtin_p)) {
            throw new \InvalidArgumentException('non-nullable gtin_p cannot be null');
        }
        $this->container['gtin_p'] = $gtin_p;

        return $this;
    }

    /**
     * Gets gtin_f
     *
     * @return string|null
     */
    public function getGtinF()
    {
        return $this->container['gtin_f'];
    }

    /**
     * Sets gtin_f
     *
     * @param string|null $gtin_f GTIN du produit concerné, si existant    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setGtinF($gtin_f)
    {
        if (is_null($gtin_f)) {
            throw new \InvalidArgumentException('non-nullable gtin_f cannot be null');
        }
        $this->container['gtin_f'] = $gtin_f;

        return $this;
    }

    /**
     * Gets p
     *
     * @return float|null
     */
    public function getP()
    {
        return $this->container['p'];
    }

    /**
     * Sets p
     *
     * @param float|null $p Pourcentage de réduction    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setP($p)
    {
        if (is_null($p)) {
            throw new \InvalidArgumentException('non-nullable p cannot be null');
        }
        $this->container['p'] = $p;

        return $this;
    }

    /**
     * Gets pvs
     *
     * @return float|null
     */
    public function getPvs()
    {
        return $this->container['pvs'];
    }

    /**
     * Sets pvs
     *
     * @param float|null $pvs Prix de vente promotionnel, TTC    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvs($pvs)
    {
        if (is_null($pvs)) {
            throw new \InvalidArgumentException('non-nullable pvs cannot be null');
        }
        $this->container['pvs'] = $pvs;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification du détail de promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


