<?php
/**
 * MetierDebitWebConnectDetailVente
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierDebitWebConnectDetailVente Class Doc Comment
 *
 * @category Class
 * @description (fullname : piu_Ventes.MetierDebit.WebConnectDetailVente)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierDebitWebConnectDetailVente implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierDebit_WebConnectDetailVente';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'retour_de' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId',
        'qte' => 'int',
        'montant_ttc' => 'float',
        'remise_ttc' => 'float',
        'type_remise' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\StatutVte',
        'taux_tva' => 'float',
        'tva' => 'float',
        'montant_ht' => 'float',
        'eco_taxe_ht' => 'float',
        'ensemble' => 'bool',
        'type_ensemble' => 'string',
        'defectueux' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'retour_de' => null,
        'qte' => 'int32',
        'montant_ttc' => 'decimal',
        'remise_ttc' => 'decimal',
        'type_remise' => null,
        'taux_tva' => 'decimal',
        'tva' => 'decimal',
        'montant_ht' => 'decimal',
        'eco_taxe_ht' => 'decimal',
        'ensemble' => null,
        'type_ensemble' => null,
        'defectueux' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'retour_de' => false,
        'qte' => false,
        'montant_ttc' => true,
        'remise_ttc' => false,
        'type_remise' => false,
        'taux_tva' => true,
        'tva' => true,
        'montant_ht' => false,
        'eco_taxe_ht' => false,
        'ensemble' => false,
        'type_ensemble' => false,
        'defectueux' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'retour_de' => 'RetourDe',
        'qte' => 'Qte',
        'montant_ttc' => 'MontantTTC',
        'remise_ttc' => 'RemiseTTC',
        'type_remise' => 'TypeRemise',
        'taux_tva' => 'TauxTVA',
        'tva' => 'TVA',
        'montant_ht' => 'MontantHT',
        'eco_taxe_ht' => 'EcoTaxeHT',
        'ensemble' => 'Ensemble',
        'type_ensemble' => 'TypeEnsemble',
        'defectueux' => 'Defectueux'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'retour_de' => 'setRetourDe',
        'qte' => 'setQte',
        'montant_ttc' => 'setMontantTtc',
        'remise_ttc' => 'setRemiseTtc',
        'type_remise' => 'setTypeRemise',
        'taux_tva' => 'setTauxTva',
        'tva' => 'setTva',
        'montant_ht' => 'setMontantHt',
        'eco_taxe_ht' => 'setEcoTaxeHt',
        'ensemble' => 'setEnsemble',
        'type_ensemble' => 'setTypeEnsemble',
        'defectueux' => 'setDefectueux'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'retour_de' => 'getRetourDe',
        'qte' => 'getQte',
        'montant_ttc' => 'getMontantTtc',
        'remise_ttc' => 'getRemiseTtc',
        'type_remise' => 'getTypeRemise',
        'taux_tva' => 'getTauxTva',
        'tva' => 'getTva',
        'montant_ht' => 'getMontantHt',
        'eco_taxe_ht' => 'getEcoTaxeHt',
        'ensemble' => 'getEnsemble',
        'type_ensemble' => 'getTypeEnsemble',
        'defectueux' => 'getDefectueux'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('retour_de', $data ?? [], null);
        $this->setIfExists('qte', $data ?? [], 1);
        $this->setIfExists('montant_ttc', $data ?? [], null);
        $this->setIfExists('remise_ttc', $data ?? [], null);
        $this->setIfExists('type_remise', $data ?? [], null);
        $this->setIfExists('taux_tva', $data ?? [], null);
        $this->setIfExists('tva', $data ?? [], null);
        $this->setIfExists('montant_ht', $data ?? [], null);
        $this->setIfExists('eco_taxe_ht', $data ?? [], null);
        $this->setIfExists('ensemble', $data ?? [], false);
        $this->setIfExists('type_ensemble', $data ?? [], null);
        $this->setIfExists('defectueux', $data ?? [], false);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Code barres de l'article, peut être un EAN fournisseur
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets retour_de
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId|null
     */
    public function getRetourDe()
    {
        return $this->container['retour_de'];
    }

    /**
     * Sets retour_de
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId|null $retour_de retour_de
     *
     * @return self
     */
    public function setRetourDe($retour_de)
    {
        if (is_null($retour_de)) {
            throw new \InvalidArgumentException('non-nullable retour_de cannot be null');
        }
        $this->container['retour_de'] = $retour_de;

        return $this;
    }

    /**
     * Gets qte
     *
     * @return int|null
     */
    public function getQte()
    {
        return $this->container['qte'];
    }

    /**
     * Sets qte
     *
     * @param int|null $qte Quantité
     *
     * @return self
     */
    public function setQte($qte)
    {
        if (is_null($qte)) {
            throw new \InvalidArgumentException('non-nullable qte cannot be null');
        }
        $this->container['qte'] = $qte;

        return $this;
    }

    /**
     * Gets montant_ttc
     *
     * @return float|null
     */
    public function getMontantTtc()
    {
        return $this->container['montant_ttc'];
    }

    /**
     * Sets montant_ttc
     *
     * @param float|null $montant_ttc Montant total TTC, remises inclues
     *
     * @return self
     */
    public function setMontantTtc($montant_ttc)
    {
        if (is_null($montant_ttc)) {
            array_push($this->openAPINullablesSetToNull, 'montant_ttc');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('montant_ttc', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['montant_ttc'] = $montant_ttc;

        return $this;
    }

    /**
     * Gets remise_ttc
     *
     * @return float|null
     */
    public function getRemiseTtc()
    {
        return $this->container['remise_ttc'];
    }

    /**
     * Sets remise_ttc
     *
     * @param float|null $remise_ttc Montant total TTC des remises accordées
     *
     * @return self
     */
    public function setRemiseTtc($remise_ttc)
    {
        if (is_null($remise_ttc)) {
            throw new \InvalidArgumentException('non-nullable remise_ttc cannot be null');
        }
        $this->container['remise_ttc'] = $remise_ttc;

        return $this;
    }

    /**
     * Gets type_remise
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\StatutVte|null
     */
    public function getTypeRemise()
    {
        return $this->container['type_remise'];
    }

    /**
     * Sets type_remise
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\StatutVte|null $type_remise type_remise
     *
     * @return self
     */
    public function setTypeRemise($type_remise)
    {
        if (is_null($type_remise)) {
            throw new \InvalidArgumentException('non-nullable type_remise cannot be null');
        }
        $this->container['type_remise'] = $type_remise;

        return $this;
    }

    /**
     * Gets taux_tva
     *
     * @return float|null
     */
    public function getTauxTva()
    {
        return $this->container['taux_tva'];
    }

    /**
     * Sets taux_tva
     *
     * @param float|null $taux_tva Taux de TVA appliqué ou vide pour TVA automatique
     *
     * @return self
     */
    public function setTauxTva($taux_tva)
    {
        if (is_null($taux_tva)) {
            array_push($this->openAPINullablesSetToNull, 'taux_tva');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taux_tva', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taux_tva'] = $taux_tva;

        return $this;
    }

    /**
     * Gets tva
     *
     * @return float|null
     */
    public function getTva()
    {
        return $this->container['tva'];
    }

    /**
     * Sets tva
     *
     * @param float|null $tva TVA; (Donnée calculé par Polaris)
     *
     * @return self
     */
    public function setTva($tva)
    {
        if (is_null($tva)) {
            array_push($this->openAPINullablesSetToNull, 'tva');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tva', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tva'] = $tva;

        return $this;
    }

    /**
     * Gets montant_ht
     *
     * @return float|null
     */
    public function getMontantHt()
    {
        return $this->container['montant_ht'];
    }

    /**
     * Sets montant_ht
     *
     * @param float|null $montant_ht Montant total HT, remises inclues; (Donnée calculé par Polaris)
     *
     * @return self
     */
    public function setMontantHt($montant_ht)
    {
        if (is_null($montant_ht)) {
            throw new \InvalidArgumentException('non-nullable montant_ht cannot be null');
        }
        $this->container['montant_ht'] = $montant_ht;

        return $this;
    }

    /**
     * Gets eco_taxe_ht
     *
     * @return float|null
     */
    public function getEcoTaxeHt()
    {
        return $this->container['eco_taxe_ht'];
    }

    /**
     * Sets eco_taxe_ht
     *
     * @param float|null $eco_taxe_ht EcoTaxe HT, remises inclues; (Donnée calculé par Polaris)
     *
     * @return self
     */
    public function setEcoTaxeHt($eco_taxe_ht)
    {
        if (is_null($eco_taxe_ht)) {
            throw new \InvalidArgumentException('non-nullable eco_taxe_ht cannot be null');
        }
        $this->container['eco_taxe_ht'] = $eco_taxe_ht;

        return $this;
    }

    /**
     * Gets ensemble
     *
     * @return bool|null
     */
    public function getEnsemble()
    {
        return $this->container['ensemble'];
    }

    /**
     * Sets ensemble
     *
     * @param bool|null $ensemble Cette article fait partie d'une vente par ensemble
     *
     * @return self
     */
    public function setEnsemble($ensemble)
    {
        if (is_null($ensemble)) {
            throw new \InvalidArgumentException('non-nullable ensemble cannot be null');
        }
        $this->container['ensemble'] = $ensemble;

        return $this;
    }

    /**
     * Gets type_ensemble
     *
     * @return string|null
     */
    public function getTypeEnsemble()
    {
        return $this->container['type_ensemble'];
    }

    /**
     * Sets type_ensemble
     *
     * @param string|null $type_ensemble Libellé de la vente par ensemble utilisé pour ce détail
     *
     * @return self
     */
    public function setTypeEnsemble($type_ensemble)
    {
        if (is_null($type_ensemble)) {
            throw new \InvalidArgumentException('non-nullable type_ensemble cannot be null');
        }
        $this->container['type_ensemble'] = $type_ensemble;

        return $this;
    }

    /**
     * Gets defectueux
     *
     * @return bool|null
     */
    public function getDefectueux()
    {
        return $this->container['defectueux'];
    }

    /**
     * Sets defectueux
     *
     * @param bool|null $defectueux Défectueux
     *
     * @return self
     */
    public function setDefectueux($defectueux)
    {
        if (is_null($defectueux)) {
            throw new \InvalidArgumentException('non-nullable defectueux cannot be null');
        }
        $this->container['defectueux'] = $defectueux;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


