<?php
/**
 * MetierClientWebConnectCarteFidelite
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierClientWebConnectCarteFidelite Class Doc Comment
 *
 * @category Class
 * @description (fullname : piu_Clients.MetierClient.WebConnectCarteFidelite)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierClientWebConnectCarteFidelite implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierClient_WebConnectCarteFidelite';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code_carte' => 'string',
        'date_valide' => '\DateTime',
        'est_valide' => 'bool',
        'nb_points' => 'int',
        'nb_articles' => 'int',
        'montant_ventes' => 'float',
        'montant_cadeaux' => 'float',
        'nb_passages' => 'int',
        'date_passage' => '\DateTime',
        'palier_bonus' => 'int',
        'index_niveau_carte' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code_carte' => null,
        'date_valide' => 'date-time',
        'est_valide' => null,
        'nb_points' => 'int32',
        'nb_articles' => 'int32',
        'montant_ventes' => 'decimal',
        'montant_cadeaux' => 'decimal',
        'nb_passages' => 'int32',
        'date_passage' => 'date-time',
        'palier_bonus' => 'int32',
        'index_niveau_carte' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code_carte' => false,
        'date_valide' => true,
        'est_valide' => false,
        'nb_points' => false,
        'nb_articles' => false,
        'montant_ventes' => false,
        'montant_cadeaux' => false,
        'nb_passages' => false,
        'date_passage' => true,
        'palier_bonus' => false,
        'index_niveau_carte' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code_carte' => 'CodeCarte',
        'date_valide' => 'DateValide',
        'est_valide' => 'EstValide',
        'nb_points' => 'NbPoints',
        'nb_articles' => 'NbArticles',
        'montant_ventes' => 'MontantVentes',
        'montant_cadeaux' => 'MontantCadeaux',
        'nb_passages' => 'NbPassages',
        'date_passage' => 'DatePassage',
        'palier_bonus' => 'PalierBonus',
        'index_niveau_carte' => 'IndexNiveauCarte'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code_carte' => 'setCodeCarte',
        'date_valide' => 'setDateValide',
        'est_valide' => 'setEstValide',
        'nb_points' => 'setNbPoints',
        'nb_articles' => 'setNbArticles',
        'montant_ventes' => 'setMontantVentes',
        'montant_cadeaux' => 'setMontantCadeaux',
        'nb_passages' => 'setNbPassages',
        'date_passage' => 'setDatePassage',
        'palier_bonus' => 'setPalierBonus',
        'index_niveau_carte' => 'setIndexNiveauCarte'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code_carte' => 'getCodeCarte',
        'date_valide' => 'getDateValide',
        'est_valide' => 'getEstValide',
        'nb_points' => 'getNbPoints',
        'nb_articles' => 'getNbArticles',
        'montant_ventes' => 'getMontantVentes',
        'montant_cadeaux' => 'getMontantCadeaux',
        'nb_passages' => 'getNbPassages',
        'date_passage' => 'getDatePassage',
        'palier_bonus' => 'getPalierBonus',
        'index_niveau_carte' => 'getIndexNiveauCarte'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code_carte', $data ?? [], null);
        $this->setIfExists('date_valide', $data ?? [], null);
        $this->setIfExists('est_valide', $data ?? [], false);
        $this->setIfExists('nb_points', $data ?? [], 0);
        $this->setIfExists('nb_articles', $data ?? [], 0);
        $this->setIfExists('montant_ventes', $data ?? [], null);
        $this->setIfExists('montant_cadeaux', $data ?? [], null);
        $this->setIfExists('nb_passages', $data ?? [], 0);
        $this->setIfExists('date_passage', $data ?? [], null);
        $this->setIfExists('palier_bonus', $data ?? [], 0);
        $this->setIfExists('index_niveau_carte', $data ?? [], 0);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code_carte
     *
     * @return string|null
     */
    public function getCodeCarte()
    {
        return $this->container['code_carte'];
    }

    /**
     * Sets code_carte
     *
     * @param string|null $code_carte Code de la carte
     *
     * @return self
     */
    public function setCodeCarte($code_carte)
    {
        if (is_null($code_carte)) {
            throw new \InvalidArgumentException('non-nullable code_carte cannot be null');
        }
        $this->container['code_carte'] = $code_carte;

        return $this;
    }

    /**
     * Gets date_valide
     *
     * @return \DateTime|null
     */
    public function getDateValide()
    {
        return $this->container['date_valide'];
    }

    /**
     * Sets date_valide
     *
     * @param \DateTime|null $date_valide Date de validité de la carte
     *
     * @return self
     */
    public function setDateValide($date_valide)
    {
        if (is_null($date_valide)) {
            array_push($this->openAPINullablesSetToNull, 'date_valide');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_valide', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_valide'] = $date_valide;

        return $this;
    }

    /**
     * Gets est_valide
     *
     * @return bool|null
     */
    public function getEstValide()
    {
        return $this->container['est_valide'];
    }

    /**
     * Sets est_valide
     *
     * @param bool|null $est_valide Code de la carte
     *
     * @return self
     */
    public function setEstValide($est_valide)
    {
        if (is_null($est_valide)) {
            throw new \InvalidArgumentException('non-nullable est_valide cannot be null');
        }
        $this->container['est_valide'] = $est_valide;

        return $this;
    }

    /**
     * Gets nb_points
     *
     * @return int|null
     */
    public function getNbPoints()
    {
        return $this->container['nb_points'];
    }

    /**
     * Sets nb_points
     *
     * @param int|null $nb_points Points sur la carte
     *
     * @return self
     */
    public function setNbPoints($nb_points)
    {
        if (is_null($nb_points)) {
            throw new \InvalidArgumentException('non-nullable nb_points cannot be null');
        }
        $this->container['nb_points'] = $nb_points;

        return $this;
    }

    /**
     * Gets nb_articles
     *
     * @return int|null
     */
    public function getNbArticles()
    {
        return $this->container['nb_articles'];
    }

    /**
     * Sets nb_articles
     *
     * @param int|null $nb_articles Nombre d'articles achetés avec cette carte depuis la dernière affectation d'un bonus
     *
     * @return self
     */
    public function setNbArticles($nb_articles)
    {
        if (is_null($nb_articles)) {
            throw new \InvalidArgumentException('non-nullable nb_articles cannot be null');
        }
        $this->container['nb_articles'] = $nb_articles;

        return $this;
    }

    /**
     * Gets montant_ventes
     *
     * @return float|null
     */
    public function getMontantVentes()
    {
        return $this->container['montant_ventes'];
    }

    /**
     * Sets montant_ventes
     *
     * @param float|null $montant_ventes Montant des ventes réalisées avec cette carte depuis la dernière affectation d'un bonus
     *
     * @return self
     */
    public function setMontantVentes($montant_ventes)
    {
        if (is_null($montant_ventes)) {
            throw new \InvalidArgumentException('non-nullable montant_ventes cannot be null');
        }
        $this->container['montant_ventes'] = $montant_ventes;

        return $this;
    }

    /**
     * Gets montant_cadeaux
     *
     * @return float|null
     */
    public function getMontantCadeaux()
    {
        return $this->container['montant_cadeaux'];
    }

    /**
     * Sets montant_cadeaux
     *
     * @param float|null $montant_cadeaux Montant Cadeaux réalisées avec cette carte depuis la dernière affectation d'un bonus
     *
     * @return self
     */
    public function setMontantCadeaux($montant_cadeaux)
    {
        if (is_null($montant_cadeaux)) {
            throw new \InvalidArgumentException('non-nullable montant_cadeaux cannot be null');
        }
        $this->container['montant_cadeaux'] = $montant_cadeaux;

        return $this;
    }

    /**
     * Gets nb_passages
     *
     * @return int|null
     */
    public function getNbPassages()
    {
        return $this->container['nb_passages'];
    }

    /**
     * Sets nb_passages
     *
     * @param int|null $nb_passages Nombre de passages effectués en présentant avec cette carte depuis la dernière affectation d'un bonus
     *
     * @return self
     */
    public function setNbPassages($nb_passages)
    {
        if (is_null($nb_passages)) {
            throw new \InvalidArgumentException('non-nullable nb_passages cannot be null');
        }
        $this->container['nb_passages'] = $nb_passages;

        return $this;
    }

    /**
     * Gets date_passage
     *
     * @return \DateTime|null
     */
    public function getDatePassage()
    {
        return $this->container['date_passage'];
    }

    /**
     * Sets date_passage
     *
     * @param \DateTime|null $date_passage Date du dernier passage en caisse
     *
     * @return self
     */
    public function setDatePassage($date_passage)
    {
        if (is_null($date_passage)) {
            array_push($this->openAPINullablesSetToNull, 'date_passage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_passage', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_passage'] = $date_passage;

        return $this;
    }

    /**
     * Gets palier_bonus
     *
     * @return int|null
     */
    public function getPalierBonus()
    {
        return $this->container['palier_bonus'];
    }

    /**
     * Sets palier_bonus
     *
     * @param int|null $palier_bonus Palier de bonus de la carte
     *
     * @return self
     */
    public function setPalierBonus($palier_bonus)
    {
        if (is_null($palier_bonus)) {
            throw new \InvalidArgumentException('non-nullable palier_bonus cannot be null');
        }
        $this->container['palier_bonus'] = $palier_bonus;

        return $this;
    }

    /**
     * Gets index_niveau_carte
     *
     * @return int|null
     */
    public function getIndexNiveauCarte()
    {
        return $this->container['index_niveau_carte'];
    }

    /**
     * Sets index_niveau_carte
     *
     * @param int|null $index_niveau_carte Index de niveau de la carte: exemple 0 : Normal, 1 : VIP ... etc
     *
     * @return self
     */
    public function setIndexNiveauCarte($index_niveau_carte)
    {
        if (is_null($index_niveau_carte)) {
            throw new \InvalidArgumentException('non-nullable index_niveau_carte cannot be null');
        }
        $this->container['index_niveau_carte'] = $index_niveau_carte;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


