# PrestaShop\Module\PrestaConnector\pol\api

L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité 


*Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*

**IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.

**Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**



For more information, please visit [https://vega-info.fr](https://vega-info.fr).

## Installation & Usage

### Requirements

PHP 7.2 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/GIT_USER_ID/GIT_REPO_ID.git"
    }
  ],
  "require": {
    "GIT_USER_ID/GIT_REPO_ID": "*@dev"
  }
}
```

Then run `composer install`

Your project is free to choose the http client of your choice
Please require packages that will provide http client functionality:
https://packagist.org/providers/psr/http-client-implementation
https://packagist.org/providers/php-http/async-client-implementation
https://packagist.org/providers/psr/http-factory-implementation

As an example:

```
composer require guzzlehttp/guzzle php-http/guzzle7-adapter http-interop/http-factory-guzzle
```

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/PrestaShop\Module\PrestaConnector\pol\api/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: Secret
$config = PrestaShop\Module\PrestaConnector\pol\api\lib\Configuration::getDefaultConfiguration()->setApiKey('X-API-Key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PrestaShop\Module\PrestaConnector\pol\api\lib\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-Key', 'Bearer');


$apiInstance = new PrestaShop\Module\PrestaConnector\pol\api\lib\Api\CatalogApi(
    // If you want use custom http client, pass your client which implements `Psr\Http\Client\ClientInterface`.
    // This is optional, `Psr18ClientDiscovery` will be used to find http client. For instance `GuzzleHttp\Client` implements that interface
    new GuzzleHttp\Client(),
    $config
);
$filtre_produit = new \PrestaShop\Module\PrestaConnector\pol\api\lib\Model\FiltreProduit(); // FiltreProduit | Si précisé, ne renvoi que les catégories des produits correspondants au filtrage
$derniere_modification = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Si précisé, ne renvoi que les catégories ayant changées depuis cette date
$pager = new \PrestaShop\Module\PrestaConnector\pol\api\lib\Model\Pager(); // Pager | Configuration de la sortie d'un résultat      Une documentation complémentaire est disponible à l'adresse [/api?doc=WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect.Pager)

try {
    $result = $apiInstance->catalogGetCategories1($filtre_produit, $derniere_modification, $pager);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogApi->catalogGetCategories1: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api/WebConnect*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CatalogApi* | [**catalogGetCategories1**](docs/Api/CatalogApi.md#cataloggetcategories1) | **GET** /Catalog/Categories1 | Obtient les informations de catégories de type 1 des produits
*CatalogApi* | [**catalogGetCategories1Ext**](docs/Api/CatalogApi.md#cataloggetcategories1ext) | **GET** /Catalog/Categories1Ext | Obtient les informations étendues de catégories de type 1 des produits
*CatalogApi* | [**catalogGetCategories2**](docs/Api/CatalogApi.md#cataloggetcategories2) | **GET** /Catalog/Categories2 | Obtient les informations de catégories de type 2 des produits
*CatalogApi* | [**catalogGetCategories2Ext**](docs/Api/CatalogApi.md#cataloggetcategories2ext) | **GET** /Catalog/Categories2Ext | Obtient les informations étendues de catégories de type 2 des produits
*CatalogApi* | [**catalogGetCategories3**](docs/Api/CatalogApi.md#cataloggetcategories3) | **GET** /Catalog/Categories3 | Obtient les informations de catégories de type 3 des produits
*CatalogApi* | [**catalogGetCategories3Ext**](docs/Api/CatalogApi.md#cataloggetcategories3ext) | **GET** /Catalog/Categories3Ext | Obtient les informations étendues de catégories de type 3 des produits
*CatalogApi* | [**catalogGetCategories4**](docs/Api/CatalogApi.md#cataloggetcategories4) | **GET** /Catalog/Categories4 | Obtient les informations de catégories de type 4 des produits
*CatalogApi* | [**catalogGetCategories4Ext**](docs/Api/CatalogApi.md#cataloggetcategories4ext) | **GET** /Catalog/Categories4Ext | Obtient les informations étendues de catégories de type 4 des produits
*CatalogApi* | [**catalogGetClassification**](docs/Api/CatalogApi.md#cataloggetclassification) | **GET** /Catalog/Classification | Obtient les informations d&#39;une classification de produits
*CatalogApi* | [**catalogGetClassifications**](docs/Api/CatalogApi.md#cataloggetclassifications) | **GET** /Catalog/Classifications | Obtient la liste des classifications utilisées des produits
*CatalogApi* | [**catalogGetClassificationsExt**](docs/Api/CatalogApi.md#cataloggetclassificationsext) | **GET** /Catalog/ClassificationsExt | Obtient les informations de classification des produits
*CatalogApi* | [**catalogGetCollections**](docs/Api/CatalogApi.md#cataloggetcollections) | **GET** /Catalog/Collections | Obtient les informations de collections des produits
*CatalogApi* | [**catalogGetGroupesThemes**](docs/Api/CatalogApi.md#cataloggetgroupesthemes) | **GET** /Catalog/GroupesThemes | Obtient les informations des groupes de thèmes des produits
*CatalogApi* | [**catalogGetMagasin**](docs/Api/CatalogApi.md#cataloggetmagasin) | **GET** /Catalog/Magasin | Obtient les informations d&#39;un magasin
*CatalogApi* | [**catalogGetMagasins**](docs/Api/CatalogApi.md#cataloggetmagasins) | **GET** /Catalog/Magasins | Obtient les informations de magasins
*CatalogApi* | [**catalogGetMagasinsExt**](docs/Api/CatalogApi.md#cataloggetmagasinsext) | **GET** /Catalog/MagasinsExt | Obtient les informations de magasins des produits
*CatalogApi* | [**catalogGetMarque**](docs/Api/CatalogApi.md#cataloggetmarque) | **GET** /Catalog/Marque | Obtient les informations d&#39;une marque de produits
*CatalogApi* | [**catalogGetMarques**](docs/Api/CatalogApi.md#cataloggetmarques) | **GET** /Catalog/Marques | Obtient les informations de marques des produits
*CatalogApi* | [**catalogGetMarquesExt**](docs/Api/CatalogApi.md#cataloggetmarquesext) | **GET** /Catalog/MarquesExt | Obtient les informations de marques des produits
*CatalogApi* | [**catalogGetNiveaux1**](docs/Api/CatalogApi.md#cataloggetniveaux1) | **GET** /Catalog/Niveaux1 | Obtient les informations de niveaux de type 1 des produits
*CatalogApi* | [**catalogGetNiveaux1Ext**](docs/Api/CatalogApi.md#cataloggetniveaux1ext) | **GET** /Catalog/Niveaux1Ext | Obtient les informations étendues de niveaux de type 1 des produits
*CatalogApi* | [**catalogGetNiveaux2**](docs/Api/CatalogApi.md#cataloggetniveaux2) | **GET** /Catalog/Niveaux2 | Obtient les informations de niveaux de type 2 des produits
*CatalogApi* | [**catalogGetNiveaux2Ext**](docs/Api/CatalogApi.md#cataloggetniveaux2ext) | **GET** /Catalog/Niveaux2Ext | Obtient les informations étendues de niveaux de type 2 des produits
*CatalogApi* | [**catalogGetNiveaux3**](docs/Api/CatalogApi.md#cataloggetniveaux3) | **GET** /Catalog/Niveaux3 | Obtient les informations de niveaux de type 3 des produits
*CatalogApi* | [**catalogGetNiveaux3Ext**](docs/Api/CatalogApi.md#cataloggetniveaux3ext) | **GET** /Catalog/Niveaux3Ext | Obtient les informations étendues de niveaux de type 3 des produits
*CatalogApi* | [**catalogGetNiveaux4**](docs/Api/CatalogApi.md#cataloggetniveaux4) | **GET** /Catalog/Niveaux4 | Obtient les informations de niveaux de type 4 des produits
*CatalogApi* | [**catalogGetNiveaux4Ext**](docs/Api/CatalogApi.md#cataloggetniveaux4ext) | **GET** /Catalog/Niveaux4Ext | Obtient les informations étendues de niveaux de type 4 des produits
*CatalogApi* | [**catalogGetProduits**](docs/Api/CatalogApi.md#cataloggetproduits) | **GET** /Catalog/Produits | Obtient les produits
*CatalogApi* | [**catalogGetProduitsInvalides**](docs/Api/CatalogApi.md#cataloggetproduitsinvalides) | **GET** /Catalog/ProduitsInvalides | Obtient les produits invalidés
*CatalogApi* | [**catalogGetSaisons**](docs/Api/CatalogApi.md#cataloggetsaisons) | **GET** /Catalog/Saisons | Obtient les informations de saisons des produits
*CatalogApi* | [**catalogGetTailles**](docs/Api/CatalogApi.md#cataloggettailles) | **GET** /Catalog/Tailles | Obtient les informations de tailles des produits
*CatalogApi* | [**catalogGetThemes**](docs/Api/CatalogApi.md#cataloggetthemes) | **GET** /Catalog/Themes | Obtient les informations des thèmes des produits
*CatalogApi* | [**catalogGetThemesExt**](docs/Api/CatalogApi.md#cataloggetthemesext) | **GET** /Catalog/ThemesExt | Obtient les informations de thèmes des produits
*ClientsApi* | [**clientsDeleteClient**](docs/Api/ClientsApi.md#clientsdeleteclient) | **DELETE** /Clients/Client | Marque un compte client pour sa suppression.
*ClientsApi* | [**clientsGetBon**](docs/Api/ClientsApi.md#clientsgetbon) | **GET** /Clients/Bon | Obtient un bon en fonction de son code
*ClientsApi* | [**clientsGetBons**](docs/Api/ClientsApi.md#clientsgetbons) | **GET** /Clients/Bons | Obtient une liste de bons
*ClientsApi* | [**clientsGetCartePrePaye**](docs/Api/ClientsApi.md#clientsgetcarteprepaye) | **GET** /Clients/CartePrePaye | Obtient une carte prépayée en fonction de son code
*ClientsApi* | [**clientsGetCartePrePayes**](docs/Api/ClientsApi.md#clientsgetcarteprepayes) | **GET** /Clients/CartePrePayes | Obtient une liste des cartes prépayées
*ClientsApi* | [**clientsGetClient**](docs/Api/ClientsApi.md#clientsgetclient) | **GET** /Clients/Client | Obtient un client précis
*ClientsApi* | [**clientsGetClients**](docs/Api/ClientsApi.md#clientsgetclients) | **GET** /Clients/Clients | Obtient les clients
*ClientsApi* | [**clientsGetDiffusion**](docs/Api/ClientsApi.md#clientsgetdiffusion) | **GET** /Clients/Diffusion | Obtient les listes de diffusion des clients
*ClientsApi* | [**clientsPostBon**](docs/Api/ClientsApi.md#clientspostbon) | **POST** /Clients/Bon | Crée un nouveau bon
*ClientsApi* | [**clientsPostClient**](docs/Api/ClientsApi.md#clientspostclient) | **POST** /Clients/Client | Créer un nouveau client ou modifie un client existant s&#39;il est déjà trouvé dans la base de données.
*ClientsApi* | [**clientsPutClientCarte**](docs/Api/ClientsApi.md#clientsputclientcarte) | **PUT** /Clients/ClientCarte | Modifie le nombre de points
*ConfigApi* | [**configGetStruture**](docs/Api/ConfigApi.md#configgetstruture) | **GET** /Config/Struture | Obtient les informations sur le connecteur mis à disposition par ces API
*ConfigApi* | [**configGetWebCatalogApp**](docs/Api/ConfigApi.md#configgetwebcatalogapp) | **GET** /Config/WebCatalogApp | Obtient la configuration sur le WebCatalog si cet accès est paramétré pour l&#39;utilisation d&#39;un catalogue Web
*MediaApi* | [**mediaGetPhoto**](docs/Api/MediaApi.md#mediagetphoto) | **GET** /Media/Photo | Obtient la photo correspondant à l&#39;identifiant fourni
*MediaApi* | [**mediaPutUrl**](docs/Api/MediaApi.md#mediaputurl) | **PUT** /Media/Url | Poste les URL du site
*StocksApi* | [**stocksGetCommandes**](docs/Api/StocksApi.md#stocksgetcommandes) | **GET** /Stocks/Commandes | Obtient les commandes en cours. ATTENTION : les données de L&#39;API ne font ressortir que les quantités en commandes supérieures à zéro. Donc quand un article n&#39;est plus en commande les données n&#39;existent pas dans le JSON de retour
*StocksApi* | [**stocksGetDetailsPromotions**](docs/Api/StocksApi.md#stocksgetdetailspromotions) | **GET** /Stocks/DetailsPromotions | Obtient les détails des plans de promotions.
*StocksApi* | [**stocksGetPromotions**](docs/Api/StocksApi.md#stocksgetpromotions) | **GET** /Stocks/Promotions | Obtient les promotions en cours et à venir
*StocksApi* | [**stocksGetStocks**](docs/Api/StocksApi.md#stocksgetstocks) | **GET** /Stocks/Stocks | Obtient les changements de stocks et de prix.
*StocksApi* | [**stocksGetTransfert**](docs/Api/StocksApi.md#stocksgettransfert) | **GET** /Stocks/Transfert | Contrôler un mouvement de stock
*StocksApi* | [**stocksGetVenteEnGros**](docs/Api/StocksApi.md#stocksgetventeengros) | **GET** /Stocks/VenteEnGros | Contrôler une vente en gros
*StocksApi* | [**stocksPostConfirmationTransfert**](docs/Api/StocksApi.md#stockspostconfirmationtransfert) | **POST** /Stocks/ConfirmationTransfert | Indique la confirmation d&#39;un transfert ou d&#39;une commande interne
*StocksApi* | [**stocksPostTransfert**](docs/Api/StocksApi.md#stocksposttransfert) | **POST** /Stocks/Transfert | Créer un mouvement de stock en deux magasins
*StocksApi* | [**stocksPostVenteEnGros**](docs/Api/StocksApi.md#stockspostventeengros) | **POST** /Stocks/VenteEnGros | Créer d&#39;une vente en gros
*VentesApi* | [**ventesDeleteReservation**](docs/Api/VentesApi.md#ventesdeletereservation) | **DELETE** /Ventes/Reservation | Annule une réservation
*VentesApi* | [**ventesDeleteVente**](docs/Api/VentesApi.md#ventesdeletevente) | **DELETE** /Ventes/Vente | Annule une vente précédemment créée sur le système. Vous ne pouvez effacer qu&#39;une vente que vous avez créé avec vos références extérieures.
*VentesApi* | [**ventesGetReservations**](docs/Api/VentesApi.md#ventesgetreservations) | **GET** /Ventes/Reservations | Obtenir les réservations du système
*VentesApi* | [**ventesGetVentes**](docs/Api/VentesApi.md#ventesgetventes) | **GET** /Ventes/Ventes | Liste les ventes Les données ne doivent pas être stockées sur le serveur web pour des raisons de RGPD
*VentesApi* | [**ventesPostReservation**](docs/Api/VentesApi.md#ventespostreservation) | **POST** /Ventes/Reservation | Crée une nouvelle réservation
*VentesApi* | [**ventesPostReservationPrepaiement**](docs/Api/VentesApi.md#ventespostreservationprepaiement) | **POST** /Ventes/ReservationPrepaiement | Prépaye une réservation
*VentesApi* | [**ventesPostVente**](docs/Api/VentesApi.md#ventespostvente) | **POST** /Ventes/Vente | Crée une nouvelle vente sur le système

## Models

- [CdeDateMagasin](docs/Model/CdeDateMagasin.md)
- [CdeDetailTaille](docs/Model/CdeDetailTaille.md)
- [DateEvenement](docs/Model/DateEvenement.md)
- [DemandeAnnulationDebit](docs/Model/DemandeAnnulationDebit.md)
- [DetailPromotion](docs/Model/DetailPromotion.md)
- [FiltreProduit](docs/Model/FiltreProduit.md)
- [InfoCatalogue](docs/Model/InfoCatalogue.md)
- [InfoConnect](docs/Model/InfoConnect.md)
- [InfoUtilisation](docs/Model/InfoUtilisation.md)
- [MediaTypeUrl](docs/Model/MediaTypeUrl.md)
- [MetierBonWebConnectBonClient](docs/Model/MetierBonWebConnectBonClient.md)
- [MetierBonWebConnectBonClientUpdateable](docs/Model/MetierBonWebConnectBonClientUpdateable.md)
- [MetierCPCarteWebConnectCartePrePayeeClient](docs/Model/MetierCPCarteWebConnectCartePrePayeeClient.md)
- [MetierCategorieWebConnectCategorie](docs/Model/MetierCategorieWebConnectCategorie.md)
- [MetierCategorieWebConnectCategorieComplete](docs/Model/MetierCategorieWebConnectCategorieComplete.md)
- [MetierCategorieWebConnectProductCategorie](docs/Model/MetierCategorieWebConnectProductCategorie.md)
- [MetierCdeClientCdeClientState](docs/Model/MetierCdeClientCdeClientState.md)
- [MetierClassificationWebConnectClassification](docs/Model/MetierClassificationWebConnectClassification.md)
- [MetierClassificationWebConnectClassificationComplete](docs/Model/MetierClassificationWebConnectClassificationComplete.md)
- [MetierCliDiffusionWebConnecListDiffusionId](docs/Model/MetierCliDiffusionWebConnecListDiffusionId.md)
- [MetierClientWebConnectAdresse](docs/Model/MetierClientWebConnectAdresse.md)
- [MetierClientWebConnectCarteFidelite](docs/Model/MetierClientWebConnectCarteFidelite.md)
- [MetierClientWebConnectCarteFideliteModification](docs/Model/MetierClientWebConnectCarteFideliteModification.md)
- [MetierClientWebConnectClient](docs/Model/MetierClientWebConnectClient.md)
- [MetierClientWebConnectClientEvents](docs/Model/MetierClientWebConnectClientEvents.md)
- [MetierClientWebConnectClientId](docs/Model/MetierClientWebConnectClientId.md)
- [MetierClientWebConnectClientMinimal](docs/Model/MetierClientWebConnectClientMinimal.md)
- [MetierClientWebConnectClientUpdateable](docs/Model/MetierClientWebConnectClientUpdateable.md)
- [MetierClientWebConnectFiltreClient](docs/Model/MetierClientWebConnectFiltreClient.md)
- [MetierClientWebConnectFiltreClientVente](docs/Model/MetierClientWebConnectFiltreClientVente.md)
- [MetierClientWebConnextDetailVente](docs/Model/MetierClientWebConnextDetailVente.md)
- [MetierClientWebConnextTicket](docs/Model/MetierClientWebConnextTicket.md)
- [MetierCollectionWebConnectCollection](docs/Model/MetierCollectionWebConnectCollection.md)
- [MetierCollectionWebConnectProductCollection](docs/Model/MetierCollectionWebConnectProductCollection.md)
- [MetierDebitBonUtilise](docs/Model/MetierDebitBonUtilise.md)
- [MetierDebitWebConnectCartePrePayee](docs/Model/MetierDebitWebConnectCartePrePayee.md)
- [MetierDebitWebConnectDetailVente](docs/Model/MetierDebitWebConnectDetailVente.md)
- [MetierDebitWebConnectReglement](docs/Model/MetierDebitWebConnectReglement.md)
- [MetierDebitWebConnectVente](docs/Model/MetierDebitWebConnectVente.md)
- [MetierDebitWebConnectVenteId](docs/Model/MetierDebitWebConnectVenteId.md)
- [MetierDebitWebConnectVenteUpdateable](docs/Model/MetierDebitWebConnectVenteUpdateable.md)
- [MetierGroupeThemesWebConnectGroupeThemes](docs/Model/MetierGroupeThemesWebConnectGroupeThemes.md)
- [MetierMagasinWebConnectMagasin](docs/Model/MetierMagasinWebConnectMagasin.md)
- [MetierMagasinWebConnectMagasinComplet](docs/Model/MetierMagasinWebConnectMagasinComplet.md)
- [MetierMarqueWebConnectMarque](docs/Model/MetierMarqueWebConnectMarque.md)
- [MetierMarqueWebConnectMarqueComplete](docs/Model/MetierMarqueWebConnectMarqueComplete.md)
- [MetierMvtPolitiqueDeSaisie](docs/Model/MetierMvtPolitiqueDeSaisie.md)
- [MetierMvtWebConnectConfirmationTransfertCreation](docs/Model/MetierMvtWebConnectConfirmationTransfertCreation.md)
- [MetierMvtWebConnectConfirmationTransfertCreationDetail](docs/Model/MetierMvtWebConnectConfirmationTransfertCreationDetail.md)
- [MetierMvtWebConnectConfirmationTransfertCreationDetailResponse](docs/Model/MetierMvtWebConnectConfirmationTransfertCreationDetailResponse.md)
- [MetierMvtWebConnectConfirmationTransfertCreationReponse](docs/Model/MetierMvtWebConnectConfirmationTransfertCreationReponse.md)
- [MetierMvtWebConnectTransfert](docs/Model/MetierMvtWebConnectTransfert.md)
- [MetierMvtWebConnectTransfertCollection](docs/Model/MetierMvtWebConnectTransfertCollection.md)
- [MetierMvtWebConnectTransfertCreation](docs/Model/MetierMvtWebConnectTransfertCreation.md)
- [MetierMvtWebConnectTransfertCreationDetail](docs/Model/MetierMvtWebConnectTransfertCreationDetail.md)
- [MetierMvtWebConnectTransfertDetail](docs/Model/MetierMvtWebConnectTransfertDetail.md)
- [MetierMvtWebConnectTransfertDetailStatus](docs/Model/MetierMvtWebConnectTransfertDetailStatus.md)
- [MetierMvtWebConnectTransfertReceptionDetailStatus](docs/Model/MetierMvtWebConnectTransfertReceptionDetailStatus.md)
- [MetierMvtWebConnectTransfertStatus](docs/Model/MetierMvtWebConnectTransfertStatus.md)
- [MetierMvtWebConnectTypesTransfert](docs/Model/MetierMvtWebConnectTypesTransfert.md)
- [MetierMvtWebConnectTypesVenteEnGros](docs/Model/MetierMvtWebConnectTypesVenteEnGros.md)
- [MetierMvtWebConnectVenteEnGros](docs/Model/MetierMvtWebConnectVenteEnGros.md)
- [MetierMvtWebConnectVenteEnGrosCreation](docs/Model/MetierMvtWebConnectVenteEnGrosCreation.md)
- [MetierMvtWebConnectVenteEnGrosCreationDetail](docs/Model/MetierMvtWebConnectVenteEnGrosCreationDetail.md)
- [MetierMvtWebConnectVenteEnGrostDetail](docs/Model/MetierMvtWebConnectVenteEnGrostDetail.md)
- [MetierNiveauWebConnectNiveau](docs/Model/MetierNiveauWebConnectNiveau.md)
- [MetierNiveauWebConnectNiveauComplete](docs/Model/MetierNiveauWebConnectNiveauComplete.md)
- [MetierNiveauWebConnectProductNiveau](docs/Model/MetierNiveauWebConnectProductNiveau.md)
- [MetierSaisonWebConnectSaison](docs/Model/MetierSaisonWebConnectSaison.md)
- [MetierTailleWebConnectTaille](docs/Model/MetierTailleWebConnectTaille.md)
- [MetierThemeWebConnectTheme](docs/Model/MetierThemeWebConnectTheme.md)
- [MetierThemeWebConnectThemeComplete](docs/Model/MetierThemeWebConnectThemeComplete.md)
- [PagedResultDetailPromotion](docs/Model/PagedResultDetailPromotion.md)
- [PagedResultMetierBonWebConnectBonClient](docs/Model/PagedResultMetierBonWebConnectBonClient.md)
- [PagedResultMetierCPCarteWebConnectCartePrePayeeClient](docs/Model/PagedResultMetierCPCarteWebConnectCartePrePayeeClient.md)
- [PagedResultMetierCategorieWebConnectCategorie](docs/Model/PagedResultMetierCategorieWebConnectCategorie.md)
- [PagedResultMetierCategorieWebConnectCategorieComplete](docs/Model/PagedResultMetierCategorieWebConnectCategorieComplete.md)
- [PagedResultMetierClassificationWebConnectClassification](docs/Model/PagedResultMetierClassificationWebConnectClassification.md)
- [PagedResultMetierClassificationWebConnectClassificationComplete](docs/Model/PagedResultMetierClassificationWebConnectClassificationComplete.md)
- [PagedResultMetierClientWebConnectClient](docs/Model/PagedResultMetierClientWebConnectClient.md)
- [PagedResultMetierClientWebConnextTicket](docs/Model/PagedResultMetierClientWebConnextTicket.md)
- [PagedResultMetierCollectionWebConnectCollection](docs/Model/PagedResultMetierCollectionWebConnectCollection.md)
- [PagedResultMetierGroupeThemesWebConnectGroupeThemes](docs/Model/PagedResultMetierGroupeThemesWebConnectGroupeThemes.md)
- [PagedResultMetierMagasinWebConnectMagasin](docs/Model/PagedResultMetierMagasinWebConnectMagasin.md)
- [PagedResultMetierMagasinWebConnectMagasinComplet](docs/Model/PagedResultMetierMagasinWebConnectMagasinComplet.md)
- [PagedResultMetierMarqueWebConnectMarque](docs/Model/PagedResultMetierMarqueWebConnectMarque.md)
- [PagedResultMetierMarqueWebConnectMarqueComplete](docs/Model/PagedResultMetierMarqueWebConnectMarqueComplete.md)
- [PagedResultMetierNiveauWebConnectNiveau](docs/Model/PagedResultMetierNiveauWebConnectNiveau.md)
- [PagedResultMetierNiveauWebConnectNiveauComplete](docs/Model/PagedResultMetierNiveauWebConnectNiveauComplete.md)
- [PagedResultMetierSaisonWebConnectSaison](docs/Model/PagedResultMetierSaisonWebConnectSaison.md)
- [PagedResultMetierTailleWebConnectTaille](docs/Model/PagedResultMetierTailleWebConnectTaille.md)
- [PagedResultMetierThemeWebConnectTheme](docs/Model/PagedResultMetierThemeWebConnectTheme.md)
- [PagedResultMetierThemeWebConnectThemeComplete](docs/Model/PagedResultMetierThemeWebConnectThemeComplete.md)
- [PagedResultProduit](docs/Model/PagedResultProduit.md)
- [PagedResultPromotion](docs/Model/PagedResultPromotion.md)
- [PagedResultRefProduitInvalide](docs/Model/PagedResultRefProduitInvalide.md)
- [PagedResultReleveCde](docs/Model/PagedResultReleveCde.md)
- [PagedResultReleveStock](docs/Model/PagedResultReleveStock.md)
- [PagedResultWebConnectReservation](docs/Model/PagedResultWebConnectReservation.md)
- [Pager](docs/Model/Pager.md)
- [PhotoSize](docs/Model/PhotoSize.md)
- [Produit](docs/Model/Produit.md)
- [ProduitDetailMagasin](docs/Model/ProduitDetailMagasin.md)
- [ProduitDetailTaille](docs/Model/ProduitDetailTaille.md)
- [ProduitPropriete](docs/Model/ProduitPropriete.md)
- [ProduitTheme](docs/Model/ProduitTheme.md)
- [Promotion](docs/Model/Promotion.md)
- [RefProduitInvalide](docs/Model/RefProduitInvalide.md)
- [ReleveCde](docs/Model/ReleveCde.md)
- [ReleveStock](docs/Model/ReleveStock.md)
- [ServerError](docs/Model/ServerError.md)
- [StatutVte](docs/Model/StatutVte.md)
- [TTypeBon](docs/Model/TTypeBon.md)
- [Telephone](docs/Model/Telephone.md)
- [TypeMedia](docs/Model/TypeMedia.md)
- [TypeVenteInternet](docs/Model/TypeVenteInternet.md)
- [WebConnectFiltreReservation](docs/Model/WebConnectFiltreReservation.md)
- [WebConnectReservation](docs/Model/WebConnectReservation.md)
- [WebConnectReservationCreation](docs/Model/WebConnectReservationCreation.md)
- [WebConnectReservationCreationDetail](docs/Model/WebConnectReservationCreationDetail.md)
- [WebConnectReservationDetail](docs/Model/WebConnectReservationDetail.md)
- [WebConnectReservationPaiement](docs/Model/WebConnectReservationPaiement.md)
- [WebConnectReservationPaiementParBon](docs/Model/WebConnectReservationPaiementParBon.md)
- [WebConnectReservationPaiements](docs/Model/WebConnectReservationPaiements.md)
- [WebConnectReservationPrepaiement](docs/Model/WebConnectReservationPrepaiement.md)
- [WebConnectTypePrepaiement](docs/Model/WebConnectTypePrepaiement.md)

## Authorization

### Secret

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

assistance@vega-info.fr

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `14.1.99.65534`
    - Generator version: `7.8.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
