<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Forms;

use PrestaShopBundle\Form\Admin\Type\ButtonCollectionType;
use PrestaShopBundle\Form\Admin\Type\CategoryChoiceTreeType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class CategoriesMappingType extends ConnectorType{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {   
        // Obtenir les données du form passé dans le createForm
        $data = $options['data'];
        if ($data['choice'] === null) {
            $data['choice'] = [];
        }
        if (!is_array($data['choice'])) {
            $data['choice'] = [$data['choice']];
        }
        
        // On ajoute un switch pour activer ou non la synchronisation des produits de cette catégorie
        $builder->add('sync', SwitchType::class, [
            'label' => 'Synchroniser les produits de cette catégorie ?',
            'data' => !in_array(-1, $data['choice']),
            'required' => false,
            'attr' => [
                'class' => 'form-control',
            ],
        ]);

        $builder->add('choice', CategoryChoiceTreeType::class, [
            'label' => 'Catégories PrestaShop',
            'data' => $data['choice'],
            'multiple' => true,
            'required' => false,
            'attr' => [
                'class' => 'js-category-tree-list category-tree',
            ],
        ]);
        
        // On ajoute les propriétés étendues (poids par défaut des modèles sans poids défini par exemple)
        $builder->add('default_weight', TextType::class, [
            'label' => 'Poids par défaut (kg)',
            'data' => isset($data['default_weight']) ? $data['default_weight'] : '',
            'required' => false,
            'help' => 'Poids à appliquer aux produits de cette catégorie s\'ils n\'ont pas de poids défini. Laissez vide pour ne pas utiliser cette fonction. ',
            'attr' => [
                'class' => 'form-control',
            ],
        ]);
        
        $builder->add('actions', ButtonCollectionType::class, [
            'required' => false,
            'buttons' => [
                'cancel' => [
                    'type' => ButtonType::class,
                    'options' => [                        
                        'label' => 'Annuler',
                        'attr' => [
                            'class' => 'btn-form-valid btn-outline-secondary',
                            'onclick' => 'window.location.href="'.$data['cancel'].'"'
                        ]
                    ]
                ],
                'submit' => [
                    'type' => SubmitType::class,
                    'options' => [
                        'label' => 'Enregistrer',
                        'attr' => ['class' => 'btn-form-valid btn-primary']
                    ]
                ],  
                'submitAndNext' => [
                    'type' => SubmitType::class,
                    'options' => [
                        'label' => 'Enregistrer & Suivant',
                        'attr' => ['class' => 'btn-form-valid btn-primary']
                    ]
                ],           
            ],
            'attr' => [
                'class' => 'prestaconnector-row-actions',
            ],        
        ]);
    }

}