<?php 
namespace PrestaShop\Module\PolarisPrestaConnector\Controller;

use Exception;
use PolarisPrestaConnector;
use PrestaShop\Module\PolarisPrestaConnector\SyncConfiguration;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Twig\Environment;

/**
 * Tous les contrôleurs admin du module doivent dériver de cette classe 
 * qui expose un certain nombre de fonctions et de propriétés communes essentielles.
 */
class TwigRenderer
{
    private Environment $twig;

    public function __construct(Environment $twig)
    {
        $this->twig = $twig;
    }

    /**
     * Rendu d'un template Twig avec les paramètres fournis.
     */
    public function render(string $template, array $params = []): string
    {
        return $this->twig->render($template, $params);
    }
}