<?php

namespace PrestaShop\Module\PolarisPrestaConnector\Forms;

use PrestaShop\Module\PolarisPrestaConnector\SyncConfiguration;
use PrestaShopBundle\Form\Admin\Type\CustomContentType;
use Symfony\Component\Form\FormBuilderInterface;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class InformationType extends ConnectorType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $login = $this->module->getCfg()->get(SyncConfiguration::CFG_LOGIN);

        $lasts_sync = $this->module->getCfg()->get(SyncConfiguration::CFG_SYNCS_LAST);

        $guard = $this->module->getCfg()->get(SyncConfiguration::CFG_GUARD_TOKEN);

        $builder
        ->add('title_sync', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => false,
                'title' => 'Synchronisation avec le backoffice',
                'help' => '<p>                                
                                Actuellement, votre site Internet est lié au backoffice suivant : 
                           </p>
                           <pre class="bo_url">'.
                           $login['address'].
                           '</pre>',
            ],
        ])

        ->add('synchro_active', SwitchType::class, [
            'label'=>'Synchronisation activée',
            'label_attr' => ['class' => 'label-mode'],
            // Indice pour l'utilisateur sur ce que fait le mode basique et le mode complet 
            'help' => 'Active ou désactive la synchronisation des données.',            
            'required' => false,
            'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_ACTIVE ),
        ])

        ->add('cfg_mode', SwitchType::class, [
            'label'=>'Mode de synchronisation',
            'label_attr' => ['class' => 'label-mode'],
            'choices' => [
                'Mode basique' => true,
                'Mode complet' => false,
            ],
            // Indice pour l'utilisateur sur ce que fait le mode basique et le mode complet 
            'help' => 'Le mode basique synchronise les stocks, prix et promotions alors que le mode complet tient également les fiches produits à jour.',
            
            'required' => false,
            'data' => ($this->module->getCfg()->get(SyncConfiguration::CFG_WORKMODE) == 0) ? true : false,
        ])

        ->add('title_taskinterval', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Intervalles de synchronisation',
                'help' => '',
            ],
        ])

        ->add('sync_product_interval', ChoiceType::class, [
            'label' => 'Synchroniser les produits',
            'choices' => [
                'Dès que possible' => '',
                'Toutes les 10 minutes' => '10min',
                'Toutes les 20 minutes' => '20min',
                'Toutes les 30 minutes' => '30min',
                'Toutes les heures' => '1h',
                'Toutes les 2 heures' => '2h',
                'Toutes les 4 heures' => '4h',
                'Tous les jours' => 'daily',
            ],

            'expanded' => false,
            'required' => false,
            // placeholder false is important to avoid empty option in radio select despite required being false
            'placeholder' => false,
            'column_breaker' => true,
            //'help' => '', // should be set to enable help block
            'help' => 'Dernière synchro. des produits : ' . (isset($lasts_sync['sync_product']) ? 'le '.(new \Datetime($lasts_sync['sync_product']))->format('d/m/Y à H:i:s') : 'jamais'), // should be set to enable help block
            'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SYNC_PRODUCT_INTERVAL),
        ])

        ->add('sync_stock_interval', ChoiceType::class, [
            'label' => 'Synchroniser le stocks & les prix',
            'choices' => [
                'Dès que possible' => '',
                'Toutes les 10 minutes' => '10min',
                'Toutes les 20 minutes' => '20min',
                'Toutes les 30 minutes' => '30min',
                'Toutes les heures' => '1h',
                'Toutes les 2 heures' => '2h',
                'Toutes les 4 heures' => '4h',
                'Tous les jours' => 'daily',
            ],

            'expanded' => false,
            'required' => false,
            // placeholder false is important to avoid empty option in radio select despite required being false
            'placeholder' => false,
            'column_breaker' => true,
            //'help' => '', // should be set to enable help block
            'help' => 'Dernière synchro. des stocks : ' . (isset($lasts_sync['sync_stock']) ? 'le '.(new \Datetime($lasts_sync['sync_stock']))->format('d/m/Y à H:i:s') : 'jamais'), // should be set to enable help block
            'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SYNC_STOCK_INTERVAL),
        ])

        ->add('sync_full_product_interval', ChoiceType::class, [
            'label' => 'Resynchroniser totalement les produits',
            'choices' => [                
                'Tous les jours' => 'daily',
                'Toutes les semaines' => 'weekly',
                'Tous les 15 jours' => 'bi-weekly',
                'Tous les mois' => 'monthly',
            ],

            'expanded' => false,
            'required' => false,
            // placeholder false is important to avoid empty option in radio select despite required being false
            'placeholder' => false,
            'column_breaker' => true,
            //'help' => '', // should be set to enable help block
            'help' => 'Dernière resynchro. automatique des produits : ' . (isset($lasts_sync['sync_full_products']) ? 'le '.(new \Datetime($lasts_sync['sync_full_products']))->format('d/m/Y à H:i:s') : 'jamais'), // should be set to enable help block            
            'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SYNC_FULL_PRODUCT_INTERVAL),
        ])

        ->add('sync_full_stock_interval', ChoiceType::class, [
            'label' => 'Resynchroniser totalement les stocks & les prix',
            'choices' => [
                'Tous les jours' => 'daily',
                'Toutes les semaines' => 'weekly',
                'Tous les 15 jours' => 'bi-weekly',
                'Tous les mois' => 'monthly',
            ],

            'expanded' => false,
            'required' => false,
            // placeholder false is important to avoid empty option in radio select despite required being false
            'placeholder' => false,
            'column_breaker' => true,
            //'help' => '', // should be set to enable help block
            'help' => 'Dernière resynchro. automatique des stocks : ' . (isset($lasts_sync['sync_full_stock']) ? 'le '.(new \Datetime($lasts_sync['sync_full_stock']))->format('d/m/Y à H:i:s') : 'jamais'), // should be set to enable help block
            'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SYNC_FULL_STOCK_INTERVAL),
        ])
        
        ->add('title_taskcron', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Tâche de synchronisation',
                'help' => '<p>
                                Vous devez configurer une tâche cron qui appelle l\'URL suivante pour lancer la synchronisation automatiquement. 
                                Dans un cas standard, cet appel ne devrait pas être plus fréquent que toutes les 5 minutes.
                           </p>
                           <pre class="cron_url">'.\Context::getContext()->link->getBaseLink().'module/'.$this->module->name.'/cron?guard='.
                            urlencode($guard).'</pre>
                           ',
            ],
        ])

        ->add('guard_token', TextType::class, [
            'label'=>'Jeton d\'accès',
            // Indice pour l'utilisateur sur ce que fait le mode basique et le mode complet 
            'help' => 'Renseignez ici une chaîne de caractères aléatoires pour sécuriser l\'accès à la tâche de synchronisation.',
            'required' => false,
            'data' => $guard,
        ])        
        
        ->add('Enregistrer', SubmitType::class, [
            'attr' => ['class' => 'btn-form-valid btn-primary']
        ]);        
        
    }

}