<?php
/**
 * MetierClientWebConnectFiltreClient
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierClientWebConnectFiltreClient Class Doc Comment
 *
 * @category Class
 * @description Structure représentant un filtage des clients   (fullname : piu_Clients.MetierClient.WebConnectFiltreClient)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierClientWebConnectFiltreClient implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierClient_WebConnectFiltreClient';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'nos' => 'int[]',
        'mails' => 'string[]',
        'tels' => 'string[]',
        'ext_refs' => 'string[]',
        'derniere_date_modif' => '\DateTime',
        'derniere_date_vente' => '\DateTime',
        'carte_modifier' => '\DateTime',
        'ex_email' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'nos' => 'int64',
        'mails' => null,
        'tels' => null,
        'ext_refs' => null,
        'derniere_date_modif' => 'date-time',
        'derniere_date_vente' => 'date-time',
        'carte_modifier' => 'date-time',
        'ex_email' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'nos' => false,
        'mails' => false,
        'tels' => false,
        'ext_refs' => false,
        'derniere_date_modif' => true,
        'derniere_date_vente' => true,
        'carte_modifier' => true,
        'ex_email' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'nos' => 'Nos',
        'mails' => 'Mails',
        'tels' => 'Tels',
        'ext_refs' => 'ExtRefs',
        'derniere_date_modif' => 'DerniereDateModif',
        'derniere_date_vente' => 'DerniereDateVente',
        'carte_modifier' => 'CarteModifier',
        'ex_email' => 'ExEmail'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'nos' => 'setNos',
        'mails' => 'setMails',
        'tels' => 'setTels',
        'ext_refs' => 'setExtRefs',
        'derniere_date_modif' => 'setDerniereDateModif',
        'derniere_date_vente' => 'setDerniereDateVente',
        'carte_modifier' => 'setCarteModifier',
        'ex_email' => 'setExEmail'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'nos' => 'getNos',
        'mails' => 'getMails',
        'tels' => 'getTels',
        'ext_refs' => 'getExtRefs',
        'derniere_date_modif' => 'getDerniereDateModif',
        'derniere_date_vente' => 'getDerniereDateVente',
        'carte_modifier' => 'getCarteModifier',
        'ex_email' => 'getExEmail'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('nos', $data ?? [], null);
        $this->setIfExists('mails', $data ?? [], null);
        $this->setIfExists('tels', $data ?? [], null);
        $this->setIfExists('ext_refs', $data ?? [], null);
        $this->setIfExists('derniere_date_modif', $data ?? [], null);
        $this->setIfExists('derniere_date_vente', $data ?? [], null);
        $this->setIfExists('carte_modifier', $data ?? [], null);
        $this->setIfExists('ex_email', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets nos
     *
     * @return int[]|null
     */
    public function getNos()
    {
        return $this->container['nos'];
    }

    /**
     * Sets nos
     *
     * @param int[]|null $nos Filtre par numéro interne de clients
     *
     * @return self
     */
    public function setNos($nos)
    {
        if (is_null($nos)) {
            throw new \InvalidArgumentException('non-nullable nos cannot be null');
        }
        $this->container['nos'] = $nos;

        return $this;
    }

    /**
     * Gets mails
     *
     * @return string[]|null
     */
    public function getMails()
    {
        return $this->container['mails'];
    }

    /**
     * Sets mails
     *
     * @param string[]|null $mails Filtre par adresses mails
     *
     * @return self
     */
    public function setMails($mails)
    {
        if (is_null($mails)) {
            throw new \InvalidArgumentException('non-nullable mails cannot be null');
        }
        $this->container['mails'] = $mails;

        return $this;
    }

    /**
     * Gets tels
     *
     * @return string[]|null
     */
    public function getTels()
    {
        return $this->container['tels'];
    }

    /**
     * Sets tels
     *
     * @param string[]|null $tels Filtre par le télephone (Attention au indicatif du pays comme +33, recherche le numéro de téléphone avec un % exemple %601454... pour trouver 061454... ou +3361454...)
     *
     * @return self
     */
    public function setTels($tels)
    {
        if (is_null($tels)) {
            throw new \InvalidArgumentException('non-nullable tels cannot be null');
        }
        $this->container['tels'] = $tels;

        return $this;
    }

    /**
     * Gets ext_refs
     *
     * @return string[]|null
     */
    public function getExtRefs()
    {
        return $this->container['ext_refs'];
    }

    /**
     * Sets ext_refs
     *
     * @param string[]|null $ext_refs Filtre par référence externe
     *
     * @return self
     */
    public function setExtRefs($ext_refs)
    {
        if (is_null($ext_refs)) {
            throw new \InvalidArgumentException('non-nullable ext_refs cannot be null');
        }
        $this->container['ext_refs'] = $ext_refs;

        return $this;
    }

    /**
     * Gets derniere_date_modif
     *
     * @return \DateTime|null
     */
    public function getDerniereDateModif()
    {
        return $this->container['derniere_date_modif'];
    }

    /**
     * Sets derniere_date_modif
     *
     * @param \DateTime|null $derniere_date_modif Ne renvoyer que les clients modifiés depuis la date spécifiée
     *
     * @return self
     */
    public function setDerniereDateModif($derniere_date_modif)
    {
        if (is_null($derniere_date_modif)) {
            array_push($this->openAPINullablesSetToNull, 'derniere_date_modif');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('derniere_date_modif', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['derniere_date_modif'] = $derniere_date_modif;

        return $this;
    }

    /**
     * Gets derniere_date_vente
     *
     * @return \DateTime|null
     */
    public function getDerniereDateVente()
    {
        return $this->container['derniere_date_vente'];
    }

    /**
     * Sets derniere_date_vente
     *
     * @param \DateTime|null $derniere_date_vente Ne renvoyer que les clients qui sont passés en vente depuis
     *
     * @return self
     */
    public function setDerniereDateVente($derniere_date_vente)
    {
        if (is_null($derniere_date_vente)) {
            array_push($this->openAPINullablesSetToNull, 'derniere_date_vente');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('derniere_date_vente', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['derniere_date_vente'] = $derniere_date_vente;

        return $this;
    }

    /**
     * Gets carte_modifier
     *
     * @return \DateTime|null
     */
    public function getCarteModifier()
    {
        return $this->container['carte_modifier'];
    }

    /**
     * Sets carte_modifier
     *
     * @param \DateTime|null $carte_modifier Ne renvoyer que les clients dont la carte à changer
     *
     * @return self
     */
    public function setCarteModifier($carte_modifier)
    {
        if (is_null($carte_modifier)) {
            array_push($this->openAPINullablesSetToNull, 'carte_modifier');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('carte_modifier', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['carte_modifier'] = $carte_modifier;

        return $this;
    }

    /**
     * Gets ex_email
     *
     * @return bool|null
     */
    public function getExEmail()
    {
        return $this->container['ex_email'];
    }

    /**
     * Sets ex_email
     *
     * @param bool|null $ex_email Exclure les clients sans adresse e-mail, sélectionne donc que le client avec une adresse e-mail
     *
     * @return self
     */
    public function setExEmail($ex_email)
    {
        if (is_null($ex_email)) {
            array_push($this->openAPINullablesSetToNull, 'ex_email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ex_email', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ex_email'] = $ex_email;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


