<?php
    /*
        L'utilisation de FrameworkBundleAdminController est dépréciée dans PrestaShop 9.0.0 et remplacée par PrestaShopAdminController.
        Cette classe est utilisée comme base pour tous les contrôleurs d'administration du module PolarisPrestaConnector
        pour assurer la compatibilité avec les versions antérieures de PrestaShop.
        Elle fournit des fonctionnalités communes et des propriétés essentielles pour les contrôleurs d'administration du module.
        Elle est définie dans le fichier src/Controller/BaseAdminController.php.
        La classe BaseAdminController est utilisée pour dériver tous les contrôleurs d'administration du module.

        On utilise class_alias pour créer un alias de la classe PrestaShopAdminController ou FrameworkBundleAdminController
        en fonction de la version de PrestaShop.
    */

    if (version_compare(_PS_VERSION_, '9.0.0', '>=')) {
        class_alias(
            \PrestaShopBundle\Controller\Admin\PrestaShopAdminController::class,
            \PrestaShop\Module\PolarisPrestaConnector\Controller\BaseAdminController::class
        );
    } else {
        class_alias(
            \PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController::class,
            \PrestaShop\Module\PolarisPrestaConnector\Controller\BaseAdminController::class
        );
    }
