<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Models;

use DateTime;

/**
 * Objet d'interface contenant la définition d'une promotion article
 */
class DiscountPlan extends SanitizedObject
{
    /**
     * Identifiants du plan de promotion sous le backoffice
     */
    public string $id;

    /**
     * Libellé du plan de promo
     * 
     * @param string $name Libellé
     */
    public string $name;

    /**
     * Date de début
     * 
     * @param DateTime $date Date de début
     */
    public DateTime $dateStart;

    /**
     * Date de fin
     * 
     * @param DateTime $date Date de fin
     */
    public DateTime $dateEnd;    

    /**
     * Détails de la promotion
     * 
     * @param array<Discount> $discounts Détails de la promotion
     */
    public array $discounts = [];
    
    /**
     * Nouveau stock
     * 
     * @param string $code code du plan de promotion
     */
    public function __construct(
        string $id
        )
    {
        // Sanitize
        $this->id = $id;        
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {        
    }
}