<?php
/**
 * WebConnectReservation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * WebConnectReservation Class Doc Comment
 *
 * @category Class
 * @description Réservation   (fullname : piu_Ventes.CdeClient.WebConnect.WebConnectReservation)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WebConnectReservation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WebConnectReservation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'ref_ext' => 'string',
        'code_magasin' => 'int',
        'code_devise' => 'string',
        'client' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal',
        'date' => '\DateTime',
        'etat' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCdeClientCdeClientState',
        'date_annulation' => '\DateTime',
        'total_ttc' => 'float',
        'remise_ttc' => 'float',
        'details' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationDetail[]',
        'notes' => 'string',
        'prepaiements' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPrepaiement[]',
        'quarantaine' => 'bool',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code' => null,
        'ref_ext' => null,
        'code_magasin' => 'int32',
        'code_devise' => null,
        'client' => null,
        'date' => 'date-time',
        'etat' => null,
        'date_annulation' => 'date-time',
        'total_ttc' => 'decimal',
        'remise_ttc' => 'decimal',
        'details' => null,
        'notes' => null,
        'prepaiements' => null,
        'quarantaine' => null,
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code' => false,
        'ref_ext' => false,
        'code_magasin' => false,
        'code_devise' => false,
        'client' => false,
        'date' => false,
        'etat' => false,
        'date_annulation' => true,
        'total_ttc' => false,
        'remise_ttc' => false,
        'details' => false,
        'notes' => false,
        'prepaiements' => false,
        'quarantaine' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'Code',
        'ref_ext' => 'RefExt',
        'code_magasin' => 'CodeMagasin',
        'code_devise' => 'CodeDevise',
        'client' => 'Client',
        'date' => 'Date',
        'etat' => 'Etat',
        'date_annulation' => 'DateAnnulation',
        'total_ttc' => 'TotalTTC',
        'remise_ttc' => 'RemiseTTC',
        'details' => 'Details',
        'notes' => 'Notes',
        'prepaiements' => 'Prepaiements',
        'quarantaine' => 'Quarantaine',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'ref_ext' => 'setRefExt',
        'code_magasin' => 'setCodeMagasin',
        'code_devise' => 'setCodeDevise',
        'client' => 'setClient',
        'date' => 'setDate',
        'etat' => 'setEtat',
        'date_annulation' => 'setDateAnnulation',
        'total_ttc' => 'setTotalTtc',
        'remise_ttc' => 'setRemiseTtc',
        'details' => 'setDetails',
        'notes' => 'setNotes',
        'prepaiements' => 'setPrepaiements',
        'quarantaine' => 'setQuarantaine',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'ref_ext' => 'getRefExt',
        'code_magasin' => 'getCodeMagasin',
        'code_devise' => 'getCodeDevise',
        'client' => 'getClient',
        'date' => 'getDate',
        'etat' => 'getEtat',
        'date_annulation' => 'getDateAnnulation',
        'total_ttc' => 'getTotalTtc',
        'remise_ttc' => 'getRemiseTtc',
        'details' => 'getDetails',
        'notes' => 'getNotes',
        'prepaiements' => 'getPrepaiements',
        'quarantaine' => 'getQuarantaine',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('ref_ext', $data ?? [], null);
        $this->setIfExists('code_magasin', $data ?? [], 0);
        $this->setIfExists('code_devise', $data ?? [], null);
        $this->setIfExists('client', $data ?? [], null);
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('etat', $data ?? [], null);
        $this->setIfExists('date_annulation', $data ?? [], null);
        $this->setIfExists('total_ttc', $data ?? [], null);
        $this->setIfExists('remise_ttc', $data ?? [], null);
        $this->setIfExists('details', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('prepaiements', $data ?? [], null);
        $this->setIfExists('quarantaine', $data ?? [], false);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code de la réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets ref_ext
     *
     * @return string|null
     */
    public function getRefExt()
    {
        return $this->container['ref_ext'];
    }

    /**
     * Sets ref_ext
     *
     * @param string|null $ref_ext Votre référence pour cette réservation. Si précisée, doit être unique pour idempotence, non visible dans le backoffice    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefExt($ref_ext)
    {
        if (is_null($ref_ext)) {
            throw new \InvalidArgumentException('non-nullable ref_ext cannot be null');
        }
        $this->container['ref_ext'] = $ref_ext;

        return $this;
    }

    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Code du magasin dans laquelle a été effectuée cette réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            throw new \InvalidArgumentException('non-nullable code_magasin cannot be null');
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets code_devise
     *
     * @return string|null
     */
    public function getCodeDevise()
    {
        return $this->container['code_devise'];
    }

    /**
     * Sets code_devise
     *
     * @param string|null $code_devise Code internationnal de la monnaie dans laquelle est exprimée cette réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeDevise($code_devise)
    {
        if (is_null($code_devise)) {
            throw new \InvalidArgumentException('non-nullable code_devise cannot be null');
        }
        $this->container['code_devise'] = $code_devise;

        return $this;
    }

    /**
     * Gets client
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null $client client
     *
     * @return self
     */
    public function setClient($client)
    {
        if (is_null($client)) {
            throw new \InvalidArgumentException('non-nullable client cannot be null');
        }
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date Date de la réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            throw new \InvalidArgumentException('non-nullable date cannot be null');
        }
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets etat
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCdeClientCdeClientState|null
     */
    public function getEtat()
    {
        return $this->container['etat'];
    }

    /**
     * Sets etat
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCdeClientCdeClientState|null $etat etat
     *
     * @return self
     */
    public function setEtat($etat)
    {
        if (is_null($etat)) {
            throw new \InvalidArgumentException('non-nullable etat cannot be null');
        }
        $this->container['etat'] = $etat;

        return $this;
    }

    /**
     * Gets date_annulation
     *
     * @return \DateTime|null
     */
    public function getDateAnnulation()
    {
        return $this->container['date_annulation'];
    }

    /**
     * Sets date_annulation
     *
     * @param \DateTime|null $date_annulation Date de l'annulation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateAnnulation($date_annulation)
    {
        if (is_null($date_annulation)) {
            array_push($this->openAPINullablesSetToNull, 'date_annulation');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_annulation', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_annulation'] = $date_annulation;

        return $this;
    }

    /**
     * Gets total_ttc
     *
     * @return float|null
     */
    public function getTotalTtc()
    {
        return $this->container['total_ttc'];
    }

    /**
     * Sets total_ttc
     *
     * @param float|null $total_ttc Montant total de la réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTotalTtc($total_ttc)
    {
        if (is_null($total_ttc)) {
            throw new \InvalidArgumentException('non-nullable total_ttc cannot be null');
        }
        $this->container['total_ttc'] = $total_ttc;

        return $this;
    }

    /**
     * Gets remise_ttc
     *
     * @return float|null
     */
    public function getRemiseTtc()
    {
        return $this->container['remise_ttc'];
    }

    /**
     * Sets remise_ttc
     *
     * @param float|null $remise_ttc Remise accordée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRemiseTtc($remise_ttc)
    {
        if (is_null($remise_ttc)) {
            throw new \InvalidArgumentException('non-nullable remise_ttc cannot be null');
        }
        $this->container['remise_ttc'] = $remise_ttc;

        return $this;
    }

    /**
     * Gets details
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationDetail[]|null
     */
    public function getDetails()
    {
        return $this->container['details'];
    }

    /**
     * Sets details
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationDetail[]|null $details Détails de la réservation
     *
     * @return self
     */
    public function setDetails($details)
    {
        if (is_null($details)) {
            throw new \InvalidArgumentException('non-nullable details cannot be null');
        }
        $this->container['details'] = $details;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Notes sur la réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets prepaiements
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPrepaiement[]|null
     */
    public function getPrepaiements()
    {
        return $this->container['prepaiements'];
    }

    /**
     * Sets prepaiements
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPrepaiement[]|null $prepaiements Détails des règlements de la réservation
     *
     * @return self
     */
    public function setPrepaiements($prepaiements)
    {
        if (is_null($prepaiements)) {
            throw new \InvalidArgumentException('non-nullable prepaiements cannot be null');
        }
        $this->container['prepaiements'] = $prepaiements;

        return $this;
    }

    /**
     * Gets quarantaine
     *
     * @return bool|null
     */
    public function getQuarantaine()
    {
        return $this->container['quarantaine'];
    }

    /**
     * Sets quarantaine
     *
     * @param bool|null $quarantaine Vrai si la réservation doit être effacée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQuarantaine($quarantaine)
    {
        if (is_null($quarantaine)) {
            throw new \InvalidArgumentException('non-nullable quarantaine cannot be null');
        }
        $this->container['quarantaine'] = $quarantaine;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de la dernière modification de cette réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


