<?php
/**
 * MetierDebitWebConnectVente
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierDebitWebConnectVente Class Doc Comment
 *
 * @category Class
 * @description Vente   (fullname : piu_Ventes.MetierDebit.WebConnectVente)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierDebitWebConnectVente implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierDebit_WebConnectVente';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'no_ticket' => 'int',
        'code_ticket' => 'string',
        'code_debit' => 'string',
        'ref_ext' => 'string',
        'type_vente_internet' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeVenteInternet',
        'client' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal',
        'code_magasin' => 'int',
        'code_caisse' => 'int',
        'code_caissier' => 'int',
        'code_carte_fidelite' => 'string',
        'date_vente' => '\DateTime',
        'memo' => 'string',
        'details' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectDetailVente[]',
        'utiliser_bons' => 'string[]',
        'utiliser_bons_v2' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitBonUtilise[]',
        'reglements' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectReglement[]',
        'utiliser_carte_pre_payees' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]',
        'recharge_carte_pre_payees' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'no_ticket' => 'int64',
        'code_ticket' => null,
        'code_debit' => null,
        'ref_ext' => null,
        'type_vente_internet' => null,
        'client' => null,
        'code_magasin' => 'int32',
        'code_caisse' => 'int32',
        'code_caissier' => 'int32',
        'code_carte_fidelite' => null,
        'date_vente' => 'date-time',
        'memo' => null,
        'details' => null,
        'utiliser_bons' => null,
        'utiliser_bons_v2' => null,
        'reglements' => null,
        'utiliser_carte_pre_payees' => null,
        'recharge_carte_pre_payees' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'no_ticket' => true,
        'code_ticket' => false,
        'code_debit' => false,
        'ref_ext' => false,
        'type_vente_internet' => false,
        'client' => false,
        'code_magasin' => true,
        'code_caisse' => true,
        'code_caissier' => true,
        'code_carte_fidelite' => false,
        'date_vente' => true,
        'memo' => false,
        'details' => false,
        'utiliser_bons' => false,
        'utiliser_bons_v2' => false,
        'reglements' => false,
        'utiliser_carte_pre_payees' => false,
        'recharge_carte_pre_payees' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'no_ticket' => 'NoTicket',
        'code_ticket' => 'CodeTicket',
        'code_debit' => 'CodeDebit',
        'ref_ext' => 'RefExt',
        'type_vente_internet' => 'TypeVenteInternet',
        'client' => 'Client',
        'code_magasin' => 'CodeMagasin',
        'code_caisse' => 'CodeCaisse',
        'code_caissier' => 'CodeCaissier',
        'code_carte_fidelite' => 'CodeCarteFidelite',
        'date_vente' => 'DateVente',
        'memo' => 'Memo',
        'details' => 'Details',
        'utiliser_bons' => 'UtiliserBons',
        'utiliser_bons_v2' => 'UtiliserBonsV2',
        'reglements' => 'Reglements',
        'utiliser_carte_pre_payees' => 'UtiliserCartePrePayees',
        'recharge_carte_pre_payees' => 'RechargeCartePrePayees'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'no_ticket' => 'setNoTicket',
        'code_ticket' => 'setCodeTicket',
        'code_debit' => 'setCodeDebit',
        'ref_ext' => 'setRefExt',
        'type_vente_internet' => 'setTypeVenteInternet',
        'client' => 'setClient',
        'code_magasin' => 'setCodeMagasin',
        'code_caisse' => 'setCodeCaisse',
        'code_caissier' => 'setCodeCaissier',
        'code_carte_fidelite' => 'setCodeCarteFidelite',
        'date_vente' => 'setDateVente',
        'memo' => 'setMemo',
        'details' => 'setDetails',
        'utiliser_bons' => 'setUtiliserBons',
        'utiliser_bons_v2' => 'setUtiliserBonsV2',
        'reglements' => 'setReglements',
        'utiliser_carte_pre_payees' => 'setUtiliserCartePrePayees',
        'recharge_carte_pre_payees' => 'setRechargeCartePrePayees'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'no_ticket' => 'getNoTicket',
        'code_ticket' => 'getCodeTicket',
        'code_debit' => 'getCodeDebit',
        'ref_ext' => 'getRefExt',
        'type_vente_internet' => 'getTypeVenteInternet',
        'client' => 'getClient',
        'code_magasin' => 'getCodeMagasin',
        'code_caisse' => 'getCodeCaisse',
        'code_caissier' => 'getCodeCaissier',
        'code_carte_fidelite' => 'getCodeCarteFidelite',
        'date_vente' => 'getDateVente',
        'memo' => 'getMemo',
        'details' => 'getDetails',
        'utiliser_bons' => 'getUtiliserBons',
        'utiliser_bons_v2' => 'getUtiliserBonsV2',
        'reglements' => 'getReglements',
        'utiliser_carte_pre_payees' => 'getUtiliserCartePrePayees',
        'recharge_carte_pre_payees' => 'getRechargeCartePrePayees'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('no_ticket', $data ?? [], null);
        $this->setIfExists('code_ticket', $data ?? [], null);
        $this->setIfExists('code_debit', $data ?? [], null);
        $this->setIfExists('ref_ext', $data ?? [], null);
        $this->setIfExists('type_vente_internet', $data ?? [], null);
        $this->setIfExists('client', $data ?? [], null);
        $this->setIfExists('code_magasin', $data ?? [], null);
        $this->setIfExists('code_caisse', $data ?? [], null);
        $this->setIfExists('code_caissier', $data ?? [], null);
        $this->setIfExists('code_carte_fidelite', $data ?? [], null);
        $this->setIfExists('date_vente', $data ?? [], null);
        $this->setIfExists('memo', $data ?? [], null);
        $this->setIfExists('details', $data ?? [], null);
        $this->setIfExists('utiliser_bons', $data ?? [], null);
        $this->setIfExists('utiliser_bons_v2', $data ?? [], null);
        $this->setIfExists('reglements', $data ?? [], null);
        $this->setIfExists('utiliser_carte_pre_payees', $data ?? [], null);
        $this->setIfExists('recharge_carte_pre_payees', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets no_ticket
     *
     * @return int|null
     */
    public function getNoTicket()
    {
        return $this->container['no_ticket'];
    }

    /**
     * Sets no_ticket
     *
     * @param int|null $no_ticket Numéro unique du ticket créée
     *
     * @return self
     */
    public function setNoTicket($no_ticket)
    {
        if (is_null($no_ticket)) {
            array_push($this->openAPINullablesSetToNull, 'no_ticket');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('no_ticket', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['no_ticket'] = $no_ticket;

        return $this;
    }

    /**
     * Gets code_ticket
     *
     * @return string|null
     */
    public function getCodeTicket()
    {
        return $this->container['code_ticket'];
    }

    /**
     * Sets code_ticket
     *
     * @param string|null $code_ticket Code unique du ticket créée (Numéro ticket formaté)
     *
     * @return self
     */
    public function setCodeTicket($code_ticket)
    {
        if (is_null($code_ticket)) {
            throw new \InvalidArgumentException('non-nullable code_ticket cannot be null');
        }
        $this->container['code_ticket'] = $code_ticket;

        return $this;
    }

    /**
     * Gets code_debit
     *
     * @return string|null
     */
    public function getCodeDebit()
    {
        return $this->container['code_debit'];
    }

    /**
     * Sets code_debit
     *
     * @param string|null $code_debit Code du ticket de vente créée
     *
     * @return self
     */
    public function setCodeDebit($code_debit)
    {
        if (is_null($code_debit)) {
            throw new \InvalidArgumentException('non-nullable code_debit cannot be null');
        }
        $this->container['code_debit'] = $code_debit;

        return $this;
    }

    /**
     * Gets ref_ext
     *
     * @return string|null
     */
    public function getRefExt()
    {
        return $this->container['ref_ext'];
    }

    /**
     * Sets ref_ext
     *
     * @param string|null $ref_ext Référence extérieure de la vente. Cette référence doit-être unique.
     *
     * @return self
     */
    public function setRefExt($ref_ext)
    {
        if (is_null($ref_ext)) {
            throw new \InvalidArgumentException('non-nullable ref_ext cannot be null');
        }
        $this->container['ref_ext'] = $ref_ext;

        return $this;
    }

    /**
     * Gets type_vente_internet
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeVenteInternet|null
     */
    public function getTypeVenteInternet()
    {
        return $this->container['type_vente_internet'];
    }

    /**
     * Sets type_vente_internet
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeVenteInternet|null $type_vente_internet type_vente_internet
     *
     * @return self
     */
    public function setTypeVenteInternet($type_vente_internet)
    {
        if (is_null($type_vente_internet)) {
            throw new \InvalidArgumentException('non-nullable type_vente_internet cannot be null');
        }
        $this->container['type_vente_internet'] = $type_vente_internet;

        return $this;
    }

    /**
     * Gets client
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null $client client
     *
     * @return self
     */
    public function setClient($client)
    {
        if (is_null($client)) {
            throw new \InvalidArgumentException('non-nullable client cannot be null');
        }
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Magasin dans lequel enregitrer la vente
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            array_push($this->openAPINullablesSetToNull, 'code_magasin');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code_magasin', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets code_caisse
     *
     * @return int|null
     */
    public function getCodeCaisse()
    {
        return $this->container['code_caisse'];
    }

    /**
     * Sets code_caisse
     *
     * @param int|null $code_caisse Code de la caisse, si connu
     *
     * @return self
     */
    public function setCodeCaisse($code_caisse)
    {
        if (is_null($code_caisse)) {
            array_push($this->openAPINullablesSetToNull, 'code_caisse');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code_caisse', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code_caisse'] = $code_caisse;

        return $this;
    }

    /**
     * Gets code_caissier
     *
     * @return int|null
     */
    public function getCodeCaissier()
    {
        return $this->container['code_caissier'];
    }

    /**
     * Sets code_caissier
     *
     * @param int|null $code_caissier Code caissier, si connu
     *
     * @return self
     */
    public function setCodeCaissier($code_caissier)
    {
        if (is_null($code_caissier)) {
            array_push($this->openAPINullablesSetToNull, 'code_caissier');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code_caissier', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code_caissier'] = $code_caissier;

        return $this;
    }

    /**
     * Gets code_carte_fidelite
     *
     * @return string|null
     */
    public function getCodeCarteFidelite()
    {
        return $this->container['code_carte_fidelite'];
    }

    /**
     * Sets code_carte_fidelite
     *
     * @param string|null $code_carte_fidelite Si une carte de fidélité a été utilisée, code de la carte.  Laissez vide pour utiliser la carte par défaut du client quand il en a une.
     *
     * @return self
     */
    public function setCodeCarteFidelite($code_carte_fidelite)
    {
        if (is_null($code_carte_fidelite)) {
            throw new \InvalidArgumentException('non-nullable code_carte_fidelite cannot be null');
        }
        $this->container['code_carte_fidelite'] = $code_carte_fidelite;

        return $this;
    }

    /**
     * Gets date_vente
     *
     * @return \DateTime|null
     */
    public function getDateVente()
    {
        return $this->container['date_vente'];
    }

    /**
     * Sets date_vente
     *
     * @param \DateTime|null $date_vente Date de la vente
     *
     * @return self
     */
    public function setDateVente($date_vente)
    {
        if (is_null($date_vente)) {
            array_push($this->openAPINullablesSetToNull, 'date_vente');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_vente', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_vente'] = $date_vente;

        return $this;
    }

    /**
     * Gets memo
     *
     * @return string|null
     */
    public function getMemo()
    {
        return $this->container['memo'];
    }

    /**
     * Sets memo
     *
     * @param string|null $memo Notes rapides sur la vente (50 caractères maximum)
     *
     * @return self
     */
    public function setMemo($memo)
    {
        if (is_null($memo)) {
            throw new \InvalidArgumentException('non-nullable memo cannot be null');
        }
        $this->container['memo'] = $memo;

        return $this;
    }

    /**
     * Gets details
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectDetailVente[]|null
     */
    public function getDetails()
    {
        return $this->container['details'];
    }

    /**
     * Sets details
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectDetailVente[]|null $details Détails de la vente
     *
     * @return self
     */
    public function setDetails($details)
    {
        if (is_null($details)) {
            throw new \InvalidArgumentException('non-nullable details cannot be null');
        }
        $this->container['details'] = $details;

        return $this;
    }

    /**
     * Gets utiliser_bons
     *
     * @return string[]|null
     */
    public function getUtiliserBons()
    {
        return $this->container['utiliser_bons'];
    }

    /**
     * Sets utiliser_bons
     *
     * @param string[]|null $utiliser_bons Liste des codes des bons à utiliser pour le règlement
     *
     * @return self
     */
    public function setUtiliserBons($utiliser_bons)
    {
        if (is_null($utiliser_bons)) {
            throw new \InvalidArgumentException('non-nullable utiliser_bons cannot be null');
        }
        $this->container['utiliser_bons'] = $utiliser_bons;

        return $this;
    }

    /**
     * Gets utiliser_bons_v2
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitBonUtilise[]|null
     */
    public function getUtiliserBonsV2()
    {
        return $this->container['utiliser_bons_v2'];
    }

    /**
     * Sets utiliser_bons_v2
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitBonUtilise[]|null $utiliser_bons_v2 Liste des codes des bons à utiliser pour le règlement (version 2). Cette version vous permet de préciser les montants des bons.
     *
     * @return self
     */
    public function setUtiliserBonsV2($utiliser_bons_v2)
    {
        if (is_null($utiliser_bons_v2)) {
            throw new \InvalidArgumentException('non-nullable utiliser_bons_v2 cannot be null');
        }
        $this->container['utiliser_bons_v2'] = $utiliser_bons_v2;

        return $this;
    }

    /**
     * Gets reglements
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectReglement[]|null
     */
    public function getReglements()
    {
        return $this->container['reglements'];
    }

    /**
     * Sets reglements
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectReglement[]|null $reglements Détails du règlement de la vente
     *
     * @return self
     */
    public function setReglements($reglements)
    {
        if (is_null($reglements)) {
            throw new \InvalidArgumentException('non-nullable reglements cannot be null');
        }
        $this->container['reglements'] = $reglements;

        return $this;
    }

    /**
     * Gets utiliser_carte_pre_payees
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]|null
     */
    public function getUtiliserCartePrePayees()
    {
        return $this->container['utiliser_carte_pre_payees'];
    }

    /**
     * Sets utiliser_carte_pre_payees
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]|null $utiliser_carte_pre_payees Détails des cartes prépayé de la vente
     *
     * @return self
     */
    public function setUtiliserCartePrePayees($utiliser_carte_pre_payees)
    {
        if (is_null($utiliser_carte_pre_payees)) {
            throw new \InvalidArgumentException('non-nullable utiliser_carte_pre_payees cannot be null');
        }
        $this->container['utiliser_carte_pre_payees'] = $utiliser_carte_pre_payees;

        return $this;
    }

    /**
     * Gets recharge_carte_pre_payees
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]|null
     */
    public function getRechargeCartePrePayees()
    {
        return $this->container['recharge_carte_pre_payees'];
    }

    /**
     * Sets recharge_carte_pre_payees
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectCartePrePayee[]|null $recharge_carte_pre_payees Détails des cartes prépayé à recharger
     *
     * @return self
     */
    public function setRechargeCartePrePayees($recharge_carte_pre_payees)
    {
        if (is_null($recharge_carte_pre_payees)) {
            throw new \InvalidArgumentException('non-nullable recharge_carte_pre_payees cannot be null');
        }
        $this->container['recharge_carte_pre_payees'] = $recharge_carte_pre_payees;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


